<?php if ( '1' == utech_get_option( 'enable_user_menu', false ) ): ?>
	<div class="author__menu">
		<?php if ( is_user_logged_in() ): ?>
			<?php echo get_avatar( get_current_user_id(), 50 ); ?>
		<?php else: ?>
			<?php echo get_avatar( get_the_author_meta( 'id' ), 50 ); ?>
		<?php endif;?>

		<?php

			/**
			 * Displays a navigation menu.
			 *
			 * @since 3.0.0
			 */
			if ( is_user_logged_in() ) {
				if ( has_nav_menu( 'user_menu_after_login' ) ) {

					wp_nav_menu( array(
						'theme_location'  => 'user_menu_after_login',
						'menu'            => 'ul',
						'container'       => 'div',
						'container_class' => 'author__menu__wrap',
						'container_id'    => 'author__menu__wrap',
						'menu_class'      => 'author__menu__list',
						'menu_id'         => 'author__menu__list',
						'depth'           => 1,
					) );
				}
			} else {
				if ( has_nav_menu( 'user_menu' ) ) {

					wp_nav_menu( array(
						'theme_location'  => 'user_menu',
						'menu'            => 'ul',
						'container'       => 'div',
						'container_class' => 'author__menu__wrap',
						'container_id'    => 'author__menu__wrap',
						'menu_class'      => 'author__menu__list',
						'menu_id'         => 'author__menu__list',
						'depth'           => 1,
					) );
				}
			}
		?>
	</div>
<?php endif;?>