<?php
/**
 * The template for displaying all pages
 *
 * This is the template that displays all pages by default.
 * Please note that this is the WordPress construct of pages
 * and that other 'pages' on your WordPress site may use a
 * different template.
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package uTech
 * @since 1.0.0
 * 
 */

get_header();


$page_meta_array = utech_metabox_value('_utech_page_metabox');
$enable_banner   = isset( $page_meta_array['enable_banner'] ) ? $page_meta_array['enable_banner'] : true;


?>
	<?php 
		if ( $enable_banner == true ) {
			if (function_exists('utech_title')) {
			    utech_title();
			}
		}
	?>
    <div class="content-area section-padding">
        <div class="container">
            <div class="row">
				<div class="col-md-12">
					<?php
					while ( have_posts() ) :
						the_post();

						if( defined( 'ELEMENTOR_VERSION' ) && \Elementor\Plugin::$instance->editor->is_edit_mode() ){
							the_content();
						}else{
							get_template_part( 'template-parts/content/content', 'page' );
						}

						if ( utech_get_option( 'disable_page_navigation',false ) == false ) :
						utech_post_navigation();
						endif;

						utech_pagination();

						// If comments are open or we have at least one comment, load up the comment template.
						if ( comments_open() || get_comments_number() ) :
							comments_template();
						endif;

					endwhile; // End of the loop.
					?>
				</div>
			</div>
		</div>
	</div>
<?php
get_footer();