<?php

/*-----------------------------------
    404 PAGE SECTION
------------------------------------*/
CSF::createSection( UTECH_OPTION_KEY,
	array(
		'parent' => 'Blog_Post_Page_Tab',
		'title'  => esc_html__( '404 Page', 'utech' ),
		'icon'   => 'fa fa-exclamation-triangle',
		'fields' => array(

			array(
				'type'    => 'subheading',
				'content' => esc_html__( '404 Page Settings', 'utech' ),
			),
			array(
				'id'    => 'error_page_img',
				'type'  => 'media',
				'title' => esc_html__( 'Upload Error Page Image', 'utech' ),
				'desc'  => esc_html__( 'Upload error page image width 1280px and height 800px or larger.', 'utech' ),
			),
			array(
				'id'                    => 'error_page_bg',
				'type'                  => 'background',
				'title'                 => esc_html__( '404 Page Background', 'utech' ),
				'subtitle'              => esc_html__( 'Set the 404 page background.', 'utech' ),
				'desc'                  => esc_html__( 'Set the 404 page background color, image and gradient color. If you set only first color field it will be a simple solid color for background and if set 2nd color field too it will be set a gradient color and if you set a image it will be set a background image.', 'utech' ),
				'background_image'      => true,
				'background_position'   => true,
				'background_repeat'     => true,
				'background_attachment' => true,
				'background_size'       => true,
				'background_gradient'   => true,
				'background_origin'     => true,
				'background_clip'       => true,
				'background_blend_mode' => true,
				'output'                => '.error404',
				'default'               => array(
					'image'      => UTECH_ROOT_IMAGE . '/404-bg.png',
					'repeat'     => 'no-repeat',
					'position'   => 'left center',
					'attachment' => 'scroll',
					'color'      => '#ffffff',
				),
			),
			array(
				'id'      => 'error_text',
				'type'    => 'text',
				'title'   => esc_html__( '404 Error Page Text', 'utech' ),
				'desc'    => esc_html__( 'Set your 404 error title.', 'utech' ),
				'default' => esc_html__( 'Oops! That page can&rsquo;t be found.', 'utech' )
			),
			array(
				'id'      => 'enable_404_search_button',
				'type'    => 'switcher',
				'title'   => esc_html__( 'Enable 404 Search Button', 'utech' ),
				'desc'    => esc_html__( 'If you want to enable or disable 404 page button you can set ( YES / NO )', 'utech' ),
				'default' => true,
			),
			array(
				'id'      => 'enable_404_blank_header',
				'type'    => 'switcher',
				'title'   => esc_html__( 'Enable 404 Blank Header?', 'utech' ),
				'desc'    => esc_html__( 'If you want to enable or disable 404 page blank header you can set ( YES / NO )', 'utech' ),
				'default' => false,
			),
			array(
				'id'      => 'enable_404_blank_footer',
				'type'    => 'switcher',
				'title'   => esc_html__( 'Enable 404 Blank Footer?', 'utech' ),
				'desc'    => esc_html__( 'If you want to enable or disable 404 page blank footer you can set ( YES / NO )', 'utech' ),
				'default' => false,
			),
		),
	)
);