<?php
/*-----------------------------------
MILICIOUS SETTING SECTION
------------------------------------*/
CSF::createSection( UTECH_OPTION_KEY,
    array(
        'title'  => esc_html__( 'Miscellaneous', 'utech' ),
        'parent' => 'WooCommerce_Tab',
        'icon'   => 'fa fa-cog',
        'fields' => array(
            array(
                'type'    => 'subheading',
                'content' => esc_html__( 'WooCommerce Miscellaneous Settings', 'utech' ),
            ),
            array(
                'id'      => 'logn_with_phone_number',
                'type'    => 'switcher',
                'title'   => esc_html__( 'Login with phone number ?', 'utech' ),
                'desc'    => esc_html__( 'If you want to enable or disable login with phone number then you can set ( YES / NO )', 'utech' ),
                'default' => false,
            ),
            array(
                'id'      => 'product_custom_currency_text_or_sign',
                'type'    => 'switcher',
                'title'   => esc_html__( 'Add Product Custom Currency Sign Or Text ?', 'utech' ),
                'desc'    => esc_html__( 'If you want to change with custom currency sing or text then you can set ( YES / NO )', 'utech' ),
                'default' => false,
            ),
            array(
                'id'         => 'product_custom_currency_text',
                'type'       => 'text',
                'title'      => esc_html__( 'Custom Currency Text', 'utech' ),
                'desc'       => esc_html__( 'Set the custom product currency text. ', 'utech' ) . sprintf( esc_html__( 'After set custom currency, you also need to change the currency %s', 'utech' ), '<a href="' . home_url( '/wp-admin/admin.php?page=wc-settings' ) . '">' . esc_html__( 'HERE', 'utech' ) . '</a>' ),
                'default'    => 'BDT',
                'dependency' => array( 'product_custom_currency_text_or_sign', '==', 'true' ),
            ),

            array(
                'id'      => 'enable_mobile_quick_actions_links',
                'type'    => 'switcher',
                'title'   => esc_html__( 'Enable Mobile Quick Action Menu WooCommerce?', 'utech' ),
                'desc'    => esc_html__( 'If you want to enable or disable quick action menu links then you can set ( YES / NO )', 'utech' ),
                'default' => false,
            ),
            
            array(
                'id'          => 'mobile_quick_actions_links',
                'type'        => 'select',
                'title'       => esc_html__( 'WooCommerce Mobile Quick Action Menu Content', 'utech' ),
                'desc'        => esc_html__( 'If you want to remove and add form woocommerce quick action menu for mobile then chose the menu items.', 'utech' ),
                'chosen'      => true,
                'multiple'    => true,
                'placeholder' => 'Select an option',
                'options'     => array(
                    'home_link'     => esc_html__( 'Home Link', 'utech' ),
                    'cart_link'     => esc_html__( 'Cart Link', 'utech' ),
                    'checkout_link' => esc_html__( 'Checkout Link', 'utech' ),
                    // 'compare_link'     => esc_html__( 'Compare Link', 'utech' ),
                    // 'recent_view_link' => esc_html__( 'Recent View Product Link', 'utech' ),
                    // 'wishlist_link'    => esc_html__( 'Wishlist Link', 'utech' ),
                    'account_link' => esc_html__( 'My Account Link', 'utech' ),
                ),
                'default'     => array(
                    1 => 'home_link',
                    2 => 'cart_link',
                    3 => 'checkout_link',
                    4 => 'account_link',
                ),
                'dependency' => array( 'enable_mobile_quick_actions_links', '==', 'true' ),
            ),

            array(
                'id'         => 'quick_actions_home_link_text',
                'type'       => 'text',
                'title'      => esc_html__( 'Custom Home Link Text', 'utech' ),
                'desc'       => esc_html__( 'Set the custom home link text.', 'utech' ),
                'default'    => 'Home',
                'dependency' => array( 'enable_mobile_quick_actions_links|mobile_quick_actions_links', '==|any', 'true|home_link' ),
            ),

            array(
                'id'         => 'quick_actions_cart_link_text',
                'type'       => 'text',
                'title'      => esc_html__( 'Custom Cart Link Text', 'utech' ),
                'desc'       => esc_html__( 'Set the custom cart link text.', 'utech' ),
                'default'    => 'Cart',
                'dependency' => array( 'enable_mobile_quick_actions_links|mobile_quick_actions_links', '==|any', 'true|cart_link' ),
            ),

            array(
                'id'         => 'quick_actions_checkout_link_text',
                'type'       => 'text',
                'title'      => esc_html__( 'Custom Checkout Link Text', 'utech' ),
                'desc'       => esc_html__( 'Set the custom checkout link text.', 'utech' ),
                'default'    => 'Checkout',
                'dependency' => array( 'enable_mobile_quick_actions_links|mobile_quick_actions_links', '==|any', 'true|checkout_link' ),
            ),

            array(
                'id'         => 'quick_actions_compare_link_text',
                'type'       => 'text',
                'title'      => esc_html__( 'Custom Compare Link Text', 'utech' ),
                'desc'       => esc_html__( 'Set the custom compare link text.', 'utech' ),
                'default'    => 'Compare',
                'dependency' => array( 'enable_mobile_quick_actions_links|mobile_quick_actions_links', '==|any', 'true|compare_link' ),
            ),

            array(
                'id'         => 'quick_actions_recent_view_link_text',
                'type'       => 'text',
                'title'      => esc_html__( 'Custom Recent View Link Text', 'utech' ),
                'desc'       => esc_html__( 'Set the custom recent view link text.', 'utech' ),
                'default'    => 'Recent View',
                'dependency' => array( 'enable_mobile_quick_actions_links|mobile_quick_actions_links', '==|any', 'true|recent_view_link' ),
            ),

            array(
                'id'         => 'quick_actions_wishlist_link_text',
                'type'       => 'text',
                'title'      => esc_html__( 'Custom Wishlist Link Text', 'utech' ),
                'desc'       => esc_html__( 'Set the custom wishlist link text.', 'utech' ),
                'default'    => 'Wishlist',
                'dependency' => array( 'enable_mobile_quick_actions_links|mobile_quick_actions_links', '==|any', 'true|wishlist_link' ),
            ),

            array(
                'id'         => 'quick_actions_account_link_text',
                'type'       => 'text',
                'title'      => esc_html__( 'Custom Account Link Text', 'utech' ),
                'desc'       => esc_html__( 'Set the custom account link text.', 'utech' ),
                'default'    => 'Account',
                'dependency' => array( 'enable_mobile_quick_actions_links|mobile_quick_actions_links', '==|any', 'true|account_link' ),
            ),
        ),
    )
);