<?php

/*-----------------------------------
PAGE MENU SECTION
------------------------------------*/
CSF::createSection( UTECH_META_KEY,
    array(
        'title'  => esc_html__( 'Main Menu', 'utech' ),
        'parent' => 'Page_Meta_Tab',
        'fields' => array(

            array(
                'type'    => 'subheading',
                'content' => esc_html__( 'Overwrite Menu In Page?', 'utech' ),
            ),
            array(
                'id'      => 'overwrite_page_navigation',
                'type'    => 'switcher',
                'title'   => esc_html__( 'Overwrite Nav Menu In Pages.', 'utech' ),
                'desc'    => esc_html__( 'If you want to set specific menu on this page then you can set ( YES / NO )', 'utech' ),
                'default' => false,
            ),
            array(
                'id'      => 'page_navigation',
                'type'    => 'select',
                'title'   => esc_html__( 'Select Menu Location', 'utech' ),
                'desc'    => esc_html__( 'You can chose and select registerd menu from type here, It will be effect in this page. This menu will be appear only in this page.', 'utech' ),
                'options' => 'menus',
                'dependency' => array( 'overwrite_page_navigation', '==', 'true' ),
            ),

            array(
                'id'      => 'overwrite_page_mobile_navigation',
                'type'    => 'switcher',
                'title'   => esc_html__( 'Overwrite Mobile Menu In Pages.', 'utech' ),
                'desc'    => esc_html__( 'If you want to set specific menu on this page then you can set ( YES / NO )', 'utech' ),
                'default' => false,
            ),
            array(
                'id'      => 'page_mobile_navigation',
                'type'    => 'select',
                'title'   => esc_html__( 'Select Mobile Menu Location', 'utech' ),
                'desc'    => esc_html__( 'You can chose and select registerd menu from type here, It will be effect in this page. This menu will be appear only in this page.', 'utech' ),
                'options' => 'menus',
                'dependency' => array( 'overwrite_page_mobile_navigation', '==', 'true' ),
            ),

            array(
                'type'    => 'subheading',
                'content' => esc_html__( 'Page Main Menu Options', 'utech' ),
            ),
            array(
                'id'      => 'enable_header_styling',
                'type'    => 'switcher',
                'title'   => esc_html__( 'Menu Custom Style ?', 'utech' ),
                'desc'    => esc_html__( 'If you want to change any header style you can check here it will be appear on this page.', 'utech' ),
                'default' => false,
            ),
            array(
                'type'       => 'subheading',
                'content'    => esc_html__( 'Menu Width & Align', 'utech' ),
                'dependency' => array( 'enable_header_styling', '==', 'true' ),
            ),
            array(
                'id'         => 'menu_width',
                'type'       => 'select',
                'title'      => esc_html__( 'Menu Container Width', 'utech' ),
                'desc'       => esc_html__( 'Set the menu with form here you can set ( FULLWIDTH / CONTAINER )', 'utech' ),
                'options'    => array(
                    'container'                 => esc_html__( 'Container', 'utech' ),
                    'container container__full' => esc_html__( 'Container Full Width', 'utech' ),
                    'container-fluid'           => esc_html__( 'Full Width', 'utech' ),
                ),
                'default'    => 'container-fluid',
                'dependency' => array( 'enable_header_styling', '==', 'true' ),
            ),
            array(
                'id'         => 'menu_align',
                'type'       => 'select',
                'title'      => esc_html__( 'Menu Text Align', 'utech' ),
                'desc'       => esc_html__( 'Set the menu text align from here', 'utech' ),
                'options'    => array(
                    'left'   => 'Left',
                    'center' => 'Center',
                    'right'  => 'Right',
                ),
                'default'    => 'center',
                'dependency' => array( 'enable_header_styling', '==', 'true' ),
            ),
            array(
                'type'       => 'subheading',
                'content'    => esc_html__( 'Menu Color', 'utech' ),
                'dependency' => array( 'enable_header_styling', '==', 'true' ),
            ),
            array(
                'id'         => 'menu_color',
                'type'       => 'color',
                'title'      => esc_html__( 'Menu Color', 'utech' ),
                'desc'       => esc_html__( 'Set the menu color by color picker', 'utech' ),
                'output'     => array(),
                'dependency' => array( 'enable_header_styling', '==', 'true' ),
            ),
            array(
                'id'         => 'menu_hover',
                'type'       => 'color',
                'title'      => esc_html__( 'Menu Hover Color', 'utech' ),
                'desc'       => esc_html__( 'Set the menu hover color by color picker', 'utech' ),
                'output'     => array(),
                'dependency' => array( 'enable_header_styling', '==', 'true' ),
            ),
            array(
                'type'       => 'subheading',
                'content'    => esc_html__( 'Menu Sticky Color', 'utech' ),
                'dependency' => array( 'enable_header_styling', '==', 'true' ),
            ),
            array(
                'id'         => 'menu_sticky_color',
                'type'       => 'color',
                'title'      => esc_html__( 'Menu Sticky Color', 'utech' ),
                'desc'       => esc_html__( 'Set the menu sticky color by color picker', 'utech' ),
                'output'     => array(),
                'dependency' => array( 'enable_header_styling', '==', 'true' ),
            ),
            array(
                'id'         => 'menu_sticky_hover_color',
                'type'       => 'color',
                'title'      => esc_html__( 'Menu Sticky Hover Color', 'utech' ),
                'desc'       => esc_html__( 'Set the menu sticky hover color by color picker', 'utech' ),
                'output'     => array(),
                'dependency' => array( 'enable_header_styling', '==', 'true' ),
            ),
            array(
                'type'       => 'subheading',
                'content'    => esc_html__( 'Menu Dropdown Color & Hover', 'utech' ),
                'dependency' => array( 'enable_header_styling', '==', 'true' ),
            ),
            array(
                'id'         => 'menu_dropdown_color',
                'type'       => 'color',
                'title'      => esc_html__( 'Menu Dropdown Color', 'utech' ),
                'desc'       => esc_html__( 'Set the menu dropdown color by color picker', 'utech' ),
                'output'     => array(),
                'dependency' => array( 'enable_header_styling', '==', 'true' ),
            ),
            array(
                'id'         => 'menu_dropdown_hover_color',
                'type'       => 'color',
                'title'      => esc_html__( 'Menu Dropdown Hover Color', 'utech' ),
                'desc'       => esc_html__( 'Set the menu dropdown hover color by color picker', 'utech' ),
                'output'     => array(),
                'dependency' => array( 'enable_header_styling', '==', 'true' ),
            ),
            array(
                'id'         => 'menu_dropdown_hover_background',
                'type'       => 'color',
                'title'      => esc_html__( 'Menu Dropdown Hover Background Color', 'utech' ),
                'desc'       => esc_html__( 'Set the menu dropdown background color by color picker', 'utech' ),
                'output'     => array(),
                'dependency' => array( 'enable_header_styling', '==', 'true' ),
            ),
            array(
                'type'       => 'subheading',
                'content'    => esc_html__( 'Menu Item Animated Border', 'utech' ),
                'dependency' => array( 'enable_header_styling', '==', 'true' ),
            ),
            array(
                'id'         => 'enable_menu_item_animated_border',
                'type'       => 'switcher',
                'title'      => esc_html__( 'Enable Menu Animated Border', 'utech' ),
                'desc'       => esc_html__( 'If you want to enable or disable animated border in menu item you can set ( YES / NO )', 'utech' ),
                'default'    => false,
                'dependency' => array( 'enable_header_styling', '==', 'true' ),
            ),
            array(
                'id'         => 'menu_item_animated_border_color',
                'type'       => 'color',
                'title'      => esc_html__( 'Menu Animated Border Color', 'utech' ),
                'desc'       => esc_html__( 'Set the menu animated border bottom color by color picker', 'utech' ),
                'output'     => array( 'background' => 'ul#nav > li.menu-item .wee' ),
                'dependency' => array( 'enable_header_styling|enable_menu_item_animated_border', '==|==', 'true|true' ),
            ),
            array(
                'id'         => 'enable_dropdown_menu_item_animated_border',
                'type'       => 'switcher',
                'title'      => esc_html__( 'Enable Dropdown Menu Animated Border', 'utech' ),
                'desc'       => esc_html__( 'If you want to enable or disable animated border in menu item you can set ( YES / NO )', 'utech' ),
                'default'    => false,
                'dependency' => array( 'enable_header_styling', '==', 'true' ),
            ),
            array(
                'id'         => 'menu_dropdown_item_animated_border_color',
                'type'       => 'color',
                'title'      => esc_html__( 'Menu Dropdown Animated Border Color', 'utech' ),
                'desc'       => esc_html__( 'Set the menu animated border bottom color by color picker', 'utech' ),
                'output'     => array( 'background' => 'ul#nav li ul li a:after' ),
                'dependency' => array( 'enable_header_styling|enable_dropdown_menu_item_animated_border', '==|==', 'true|true' ),
            ),
        ),
    )
);