<?php
/*-----------------------------------
MENU METABOX
------------------------------------*/
if ( class_exists( 'CSF' ) ) {

    $prefix = '_utech_menu';

    /*-----------------------------------
    MENU METABOX SECTION
    ------------------------------------*/
    CSF::createNavMenuOptions( $prefix, array(
        'data_type' => 'serialize',
    ) );

    /*-----------------------------------
    MENU ITEM METABOX SECTION
    ------------------------------------*/
    CSF::createSection( $prefix, array(
        'fields' => array(
            array(
                'type'    => 'subheading',
                'content' => esc_html__( 'Megamenu', 'utech' ),
            ),
            array(
                'id'      => 'drop_leff',
                'type'    => 'switcher',
                'title'   => esc_html__( 'Dropdown From Left?', 'utech' ),
                'desc'    => esc_html__( 'If you want to dropdown menu visible from left positon then you can set ( YES / NO )', 'utech' ),
                'default' => false,
            ),
            array(
                'id'      => 'enable_megamenu',
                'type'    => 'switcher',
                'title'   => esc_html__( 'Enable Megamenu?', 'utech' ),
                'desc'    => esc_html__( 'If you want to set megamenu you can set ( YES / NO )', 'utech' ),
                'default' => false,
            ),
            array(
                'id'      => 'megamenu_content_type',
                'type'    => 'select',
                'title'   => esc_html__( 'Megamenu Content Type', 'utech' ),
                'desc'    => esc_html__( 'Set the megamenu content type form here you can set ( Elementor Template / Default Menu Items )', 'utech' ),
                'options' => array(
                    'default'   => esc_html__( 'Default Menu Items', 'utech' ),
                    'elementor' => esc_html__( 'Elementor Content', 'utech' ),
                ),
                'default'    => 'default',
                'dependency' => array( 'enable_megamenu', '==', 'true' ),
            ),
            array(
                'id'      => 'megamenu_colums',
                'type'    => 'select',
                'title'   => esc_html__( 'Megamenu Columns', 'utech' ),
                'desc'    => esc_html__( 'Set the megamenu columns form here you can set ( 1,2,3,4,5,6,7,8 )', 'utech' ),
                'options' => array(
                    '2' => esc_html__( '2 Columns', 'utech' ),
                    '3' => esc_html__( '3 Columns', 'utech' ),
                    '4' => esc_html__( '4 Columns', 'utech' ),
                    '5' => esc_html__( '5 Columns', 'utech' ),
                    '6' => esc_html__( '6 Columns', 'utech' ),
                    '7' => esc_html__( '7 Columns', 'utech' ),
                    '8' => esc_html__( '8 Columns', 'utech' ),
                ),
                'default'    => '4',
                'dependency' => array( 'enable_megamenu|megamenu_content_type', '==|!=', 'true|elementor' ),
            ),
            array(
                'id'         => 'megamenu_elementor_content',
                'type'       => 'select',
                'title'      => esc_html__( 'Select Megamenu Template', 'utech' ),
                'desc'       => esc_html__( 'You can chose and select elementor megamenu content template from here..', 'utech' ),
                'options'    => utech_get_elementor_post_array(),
                'dependency' => array( 'enable_megamenu|megamenu_content_type', '==|==', 'true|elementor' ),
            ),

            array(
                'type'    => 'subheading',
                'content' => esc_html__( 'Add Menu Bedge', 'utech' ),
            ),
            array(
                'id'      => 'add_menu_bedge',
                'type'    => 'switcher',
                'title'   => esc_html__( 'Add Menu Bedge?', 'utech' ),
                'desc'    => esc_html__( 'If you want to set menu bedge you can set ( YES / NO )', 'utech' ),
                'default' => false,
            ),
            array(
                'id'         => 'menu_bedge_text',
                'type'       => 'text',
                'title'      => esc_html__( 'Set Menu Bedge Text', 'utech' ),
                'desc'       => esc_html__( 'If you want to set menu bedge you can set set here.', 'utech' ),
                'dependency' => array( 'add_menu_bedge', '==', 'true' ),
            ),

            array(
                'type'       => 'subheading',
                'content'    => esc_html__( 'Bedge Style', 'utech' ),
                'dependency' => array( 'add_menu_bedge', '==', 'true' ),
            ),
            array(
                'id'      => 'bedge_color',
                'type'    => 'color_group',
                'help'   => esc_html__( 'Please must use a background color for showing properly bedge.', 'utech' ),
                'options' => array(
                    'text_color' => esc_html__( 'Text color', 'utech' ),
                    'bg_color'   => esc_html__( 'Background color', 'utech' ),
                ),
                'default'   => array(
                    'text_color' => '#ffffff',
                    'bg_color'   => '#0045ff',
                ),
                'dependency' => array( 'add_menu_bedge', '==', 'true' ),
            ),

        ),
    ) );

}