<?php

/*-----------------------------------
CHECKOUT PAGE
------------------------------------*/
CSF::createSection( UTECH_OPTION_KEY,
    array(
        'parent' => 'WooCommerce_Tab',
        'title'  => esc_html__( 'Checkout Page', 'utech' ),
        'icon'   => 'fas fa-shopping-cart',
        'fields' => array(
            array(
                'type'    => 'subheading',
                'content' => esc_html__( 'One Page Checkout', 'utech' ),
            ),
            array(
                'id'      => 'redirect_one_page_checkout',
                'type'    => 'switcher',
                'title'   => esc_html__( 'Redirect One Page Checkout?', 'utech' ),
                'desc'    => esc_html__( 'If you want to one page checkout then you can set ( YES / NO )', 'utech' ),
                'default' => false,
            ),

            array(
                'id'      => 'remove_add_to_cart_success_message',
                'type'    => 'switcher',
                'title'   => esc_html__( 'Remove Add To Cart Success Message?', 'utech' ),
                'desc'    => esc_html__( 'If you want to remove cart success message you can set ( YES / NO )', 'utech' ),
                'default' => false,
            ),
            array(
                'id'      => 'disable_shipping_calc_on_cart',
                'type'    => 'switcher',
                'title'   => esc_html__( 'Disable Shipping Calculate On Cart Page?', 'utech' ),
                'desc'    => esc_html__( 'If you want to disable shipping cost calculating in cart page then you can set ( YES / NO )', 'utech' ),
                'default' => false,
            ),
            array(
                'id'      => 'remove_product_from_checkout',
                'type'    => 'switcher',
                'title'   => esc_html__( 'Remove Product From Checkout Table?', 'utech' ),
                'desc'    => esc_html__( 'If you want to remove product from checkout page table you can set ( YES / NO )', 'utech' ),
                'default' => false,
            ),

            array(
                'type'    => 'subheading',
                'content' => esc_html__( 'Checkout Forms & Fields', 'utech' ),
            ),
            array(
                'id'          => 'remove_checkout_fields',
                'type'        => 'select',
                'title'       => esc_html__( 'Remove Checkout Forms Fields', 'utech' ),
                'desc'        => esc_html__( 'If you want to remove and field form checkout forms then chose the fields.', 'utech' ),
                'chosen'      => true,
                'multiple'    => true,
                'placeholder' => 'Select an option',
                'options'     => array(
                    'first_name' => esc_html__( 'First Name', 'utech' ),
                    'last_name'  => esc_html__( 'Last Name', 'utech' ),
                    'country'    => esc_html__( 'Country', 'utech' ),
                    'state'      => esc_html__( 'State', 'utech' ),
                    'city'       => esc_html__( 'City', 'utech' ),
                    'postcode'   => esc_html__( 'Postcode', 'utech' ),
                    'address_1'  => esc_html__( 'Address 1', 'utech' ),
                    'address_2'  => esc_html__( 'Address 2', 'utech' ),
                    'company'    => esc_html__( 'Company', 'utech' ),
                    'phone'      => esc_html__( 'Phone', 'utech' ),
                    'email'      => esc_html__( 'Email', 'utech' ),
                ),
                'default'     => array(
                    1 => 'company',
                ),
            ),
            array(
                'id'      => 'remove_checkout_shipping_address',
                'type'    => 'switcher',
                'title'   => esc_html__( 'Remove Checkout Shipping Address?', 'utech' ),
                'desc'    => esc_html__( 'If you want to remove checkout shipping address you can set ( YES / NO )', 'utech' ),
                'default' => false,
            ),
            array(
                'id'      => 'remove_checkout_order_notes_fields',
                'type'    => 'switcher',
                'title'   => esc_html__( 'Remove Checkout Order Notes?', 'utech' ),
                'desc'    => esc_html__( 'If you want to remove order note fields you can set ( YES / NO )', 'utech' ),
                'default' => false,
            ),

            array(
                'id'      => 'change_checkout_form_first_name_label',
                'type'    => 'switcher',
                'title'   => esc_html__( 'Change Checkout Form First Name Field Label?', 'utech' ),
                'desc'    => esc_html__( 'If you want to checkout field label you can set ( YES / NO )', 'utech' ),
                'default' => false,
            ),
            array(
                'id'         => 'checkout_form_first_name_label',
                'type'       => 'text',
                'title'      => esc_html__( 'Add Checkout First Name Custom Label', 'utech' ),
                'desc'       => esc_html__( 'Set the custom checkout field label.', 'utech' ),
                'default'    => 'Your Full Name',
                'dependency' => array( 'change_checkout_form_first_name_label', '==', 'true' ),
            ),

            array(
                'id'      => 'change_checkout_form_address_1_label',
                'type'    => 'switcher',
                'title'   => esc_html__( 'Change Checkout Form Address Field Label?', 'utech' ),
                'desc'    => esc_html__( 'If you want to checkout field label you can set ( YES / NO )', 'utech' ),
                'default' => false,
            ),
            array(
                'id'         => 'checkout_form_address_1_label',
                'type'       => 'text',
                'title'      => esc_html__( 'Add Checkout Address Custom Label', 'utech' ),
                'desc'       => esc_html__( 'Set the custom checkout field label.', 'utech' ),
                'default'    => 'Delivary Address',
                'dependency' => array( 'change_checkout_form_address_1_label', '==', 'true' ),
            ),
            array(
                'id'      => 'change_checkout_form_phone_label',
                'type'    => 'switcher',
                'title'   => esc_html__( 'Change Checkout Form Phone Field Label?', 'utech' ),
                'desc'    => esc_html__( 'If you want to checkout field label you can set ( YES / NO )', 'utech' ),
                'default' => false,
            ),
            array(
                'id'         => 'checkout_form_phone_label',
                'type'       => 'text',
                'title'      => esc_html__( 'Add Checkout Phone Custom Label', 'utech' ),
                'desc'       => esc_html__( 'Set the custom checkout field label.', 'utech' ),
                'default'    => 'Your Phone Number',
                'dependency' => array( 'change_checkout_form_phone_label', '==', 'true' ),
            ),
            array(
                'id'      => 'change_checkout_shipping_method_heading',
                'type'    => 'switcher',
                'title'   => esc_html__( 'Change Checkout Shipping Heading?', 'utech' ),
                'desc'    => esc_html__( 'If you want to checkout shipping heading you can set ( YES / NO )', 'utech' ),
                'default' => false,
            ),
            array(
                'id'         => 'checkout_shipping_heading',
                'type'       => 'text',
                'title'      => esc_html__( 'Add Checkout Shipping Heading', 'utech' ),
                'desc'       => esc_html__( 'Set the custom checkout shipping heading.', 'utech' ),
                'default'    => 'Shipping',
                'dependency' => array( 'change_checkout_shipping_method_heading', '==', 'true' ),
            ),
            array(
                'id'      => 'change_place_order_button_text',
                'type'    => 'switcher',
                'title'   => esc_html__( 'Change Place Order Button Text?', 'utech' ),
                'desc'    => esc_html__( 'If you want to place order button text you can set ( YES / NO )', 'utech' ),
                'default' => false,
            ),
            array(
                'id'         => 'place_order_button_text',
                'type'       => 'text',
                'title'      => esc_html__( 'Add Place Order Button Text', 'utech' ),
                'desc'       => esc_html__( 'Set the custom place order button text.', 'utech' ),
                'default'    => 'Place Order',
                'dependency' => array( 'change_place_order_button_text', '==', 'true' ),
            ),
            array(
                'id'      => 'remove_checkout_privacy_policy_text',
                'type'    => 'switcher',
                'title'   => esc_html__( 'Remove Checkout Privacy Policy Text?', 'utech' ),
                'desc'    => esc_html__( 'If you want to remove checkout privacy policy text you can set ( YES / NO )', 'utech' ),
                'default' => false,
            ),
            array(
                'id'      => 'remove_checkout_terms_and_conditions',
                'type'    => 'switcher',
                'title'   => esc_html__( 'Remove Checkout Terms & Conditions?', 'utech' ),
                'desc'    => esc_html__( 'If you want to remove checkout terms & conditions you can set ( YES / NO )', 'utech' ),
                'default' => false,
            ),
        ),
    )
);