<?php 
/**
 * Plugin Name: Ultimate Socials
 * Description: Post Share Helper Plugin For WordPress Theme.
 * Plugin URI: http://quomodosoft.com/plugins
 * Author: Mehedi Hasan Nahid
 * Author URI: http://quomodosoft.com
 * Version: 1.0.0
 * License: GPL2
 * Text Domain: ultimate-social
 */

/*------------------------------------
    POST SHARE GENARAL
--------------------------------------*/
if(!function_exists('post_share_social')){
    function post_share_social(){
        global $post;
        $crunchifyURL   = get_permalink();
        $crunchifyTitle = str_replace( ' ', '%20', get_the_title());
        
        $twitterURL     = 'https://twitter.com/intent/tweet?text='.$crunchifyTitle.'&amp;url='.$crunchifyURL.'&amp;via=Crunchify';
        $facebookURL    = 'https://www.facebook.com/sharer/sharer.php?u='.$crunchifyURL;
        $googleURL      = 'https://plus.google.com/share?url='.$crunchifyURL;
        $linkedinURL    = 'https://www.linkedin.com/shareArticle?mini=true&url='.$crunchifyURL;
    ?>
    <ul>
        <li><a href="<?php echo esc_url($facebookURL); ?>" target="_blank"><i class="ti ti-facebook"></i></a></li>
        <li><a href="<?php echo esc_url($twitterURL); ?>" target="_blank"><i class="ti ti-twitter"></i></a></li>
        <li><a href="<?php echo esc_url($googleURL); ?>" target="_blank"><i class="ti ti-google"></i></a></li>
        <li><a href="<?php echo esc_url($linkedinURL); ?>" target="_blank"><i class="ti ti-linkedin"></i></a></li>
    </ul>
    <?php
    }
}

/*----------------------------------
    POST SHARE WITH OFFICIAL COLOR
-----------------------------------*/
if(!function_exists('post_share_social_left')){
    function post_share_social_left(){
        global $post;
        $crunchifyURL   = get_permalink();
        $crunchifyTitle = str_replace( ' ', '%20', get_the_title());
        
        $twitterURL     = 'https://twitter.com/intent/tweet?text='.$crunchifyTitle.'&amp;url='.$crunchifyURL.'&amp;via=Crunchify';
        $facebookURL    = 'https://www.facebook.com/sharer/sharer.php?u='.$crunchifyURL;
        $googleURL      = 'https://plus.google.com/share?url='.$crunchifyURL;
        $linkedinURL    = 'https://www.linkedin.com/shareArticle?mini=true&url='.$crunchifyURL;
    ?>
    <ul>
        <li><a class="facebook" href="<?php echo esc_url($facebookURL); ?>" target="_blank"><i class="ti ti-facebook"></i></a></li>
        <li><a class="twitter" href="<?php echo esc_url($twitterURL); ?>" target="_blank"><i class="ti ti-twitter"></i></a></li>
        <li><a class="google-plus" href="<?php echo esc_url($googleURL); ?>" target="_blank"><i class="ti ti-google"></i></a></li>
        <li><a class="linkedin" href="<?php echo esc_url($linkedinURL); ?>" target="_blank"><i class="ti ti-linkedin"></i></a></li>
    </ul>
    <?php
    }
}

/*------------------------------
    POST READING TIME COUNT
--------------------------------*/
/**
 * Estimates the reading time for a given piece of $content.
 *
 * @param string $content Content to calculate read time for.
 * @param int $wpm Estimated words per minute of reader.
 *
 * @returns int $time Esimated reading time.
 */
if ( !function_exists( 'ultimate_reading_time' ) ) {
    function ultimate_reading_time( $wpm = 300 ) {
        $content      = get_post_field( 'post_content', $post->ID );
        $word_count   = str_word_count( strip_tags( $content ) );
        $reading_time = ceil( $word_count / $wpm );
        if ( $reading_time == 1 ) {
            $timer = " minute";
        } else {
            $timer = " minutes";
        }
        $total_reading_time = $reading_time . $timer;
        return $total_reading_time;
    }
}

/*---------------------------------
    POST SHARE CUNT PLGIN END
----------------------------------*/
