<?php

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

class Ultimate_Positions_Element extends Widget_Base {

	public function get_name() {
		return 'PositionElement';
	}

	public function get_title() {
		return __( 'Ul Position Element', 'ultimate' );
	}

	public function get_icon() {
		return 'eicon-drag-n-drop';
	}

	public function get_categories() {
		return array('ultimate-addons');
	}

    public function get_keywords() {
        return[
            'postion element',
            'position',
            'element',
            'shape',
        ];
    }

	public static function get_animation_style(){
		return [
			'Zoom_In_Out animated'        => __('Zoom_In_Out', 'ultimate'),
			'Circle_Large animated'       => __('Circle_Large', 'ultimate'),
			'Fade_In_Out animated'        => __('Fade_In_Out', 'ultimate'),
			'littleCircle animated'       => __('littleCircle', 'ultimate'),
			'bigCircle animated'          => __('bigCircle', 'ultimate'),
			'Hoop animated'               => __('Hoop', 'ultimate'),
			'triAngle animated'           => __('triAngle', 'ultimate'),
			'littleSquare animated'       => __('littleSquare', 'ultimate'),
			'bigSquare animated'          => __('bigSquare', 'ultimate'),
			'fadeInRotate animated'       => __('fadeInRotate', 'ultimate'),
			'fadeInBack animated'         => __('fadeInBack', 'ultimate'),
			'blurFadeIn animated'         => __('blurFadeIn', 'ultimate'),
			'blurFadeInOut animated'      => __('blurFadeInOut', 'ultimate'),
			'ballBounce animated'         => __('ballBounce', 'ultimate'),
			'zoomBounce animated'         => __('zoomBounce', 'ultimate'),
			'FramesOne animated'          => __('FramesOne', 'ultimate'),
			'FramesTwo animated'          => __('FramesTwo', 'ultimate'),
			'FramesThree animated'        => __('FramesThree', 'ultimate'),
			'FramesFour animated'         => __('FramesFour', 'ultimate'),
			'FramesFive animated'         => __('FramesFive', 'ultimate'),
			'scaleUpOne animated'         => __('scaleUpOne', 'ultimate'),
			'scaleUpOne animated'         => __('scaleUpOne', 'ultimate'),
			'scaleUpTwo animated'         => __('scaleUpTwo', 'ultimate'),
			'scaleUpThree animated'       => __('scaleUpThree', 'ultimate'),
			'prettyFade animated'         => __('prettyFade', 'ultimate'),
			'fade_in animated'            => __('fade_in', 'ultimate'),
			'scaleRight animated'         => __('scaleRight', 'ultimate'),
			'scaleUpOne animated'         => __('scaleUpOne', 'ultimate'),
			'bigSpin animated'            => __('bigSpin', 'ultimate'),
			'rotated animated'            => __('rotated', 'ultimate'),
			'rotatedHalf animated'        => __('rotatedHalf', 'ultimate'),
			'rotatedHalfTwo animated'     => __('rotatedHalfTwo', 'ultimate'),
			'jump animated'               => __('jump', 'ultimate'),
			'imageBgAnim animated'        => __('imageBgAnim', 'ultimate'),
			'bgMove animated'             => __('bgMove', 'ultimate'),
			'gradientBG animated'         => __('gradientBG', 'ultimate'),
			'rippleOutOne animated'       => __('rippleOutOne', 'ultimate'),
			'rippleOuTwo animated'        => __('rippleOuTwo', 'ultimate'),
			'bounce animated'             => __('bounce','ultimate'),
			'flash animated'              => __('flash','ultimate'),
			'pulse animated'              => __('pulse','ultimate'),
			'rubberBand animated'         => __('rubberBand','ultimate'),
			'shake animated'              => __('shake','ultimate'),
			'headShake animated'          => __('headShake','ultimate'),
			'swing animated'              => __('swing','ultimate'),
			'tada animated'               => __('tada','ultimate'),
			'wobble animated'             => __('wobble','ultimate'),
			'jello animated'              => __('jello','ultimate'),
			'heartBeat animated'          => __('heartBeat','ultimate'),
			'bounceIn animated'           => __('bounceIn','ultimate'),
			'bounceInDown animated'       => __('bounceInDown','ultimate'),
			'bounceInLeft animated'       => __('bounceInLeft','ultimate'),
			'bounceInRight animated'      => __('bounceInRight','ultimate'),
			'bounceInUp animated'         => __('bounceInUp','ultimate'),
			'bounceOut animated'          => __('bounceOut','ultimate'),
			'bounceOutDown animated'      => __('bounceOutDown','ultimate'),
			'bounceOutLeft animated'      => __('bounceOutLeft','ultimate'),
			'bounceOutRight animated'     => __('bounceOutRight','ultimate'),
			'bounceOutUp animated'        => __('bounceOutUp','ultimate'),
			'fadeIn animated'             => __('fadeIn','ultimate'),
			'fadeInDown animated'         => __('fadeInDown','ultimate'),
			'fadeInDownBig animated'      => __('fadeInDownBig','ultimate'),
			'fadeInLeft animated'         => __('fadeInLeft','ultimate'),
			'fadeInLeftBig animated'      => __('fadeInLeftBig','ultimate'),
			'fadeInRight animated'        => __('fadeInRight','ultimate'),
			'fadeInRightBig animated'     => __('fadeInRightBig','ultimate'),
			'fadeInUp animated'           => __('fadeInUp','ultimate'),
			'fadeInUpBig animated'        => __('fadeInUpBig','ultimate'),
			'fadeOut animated'            => __('fadeOut','ultimate'),
			'fadeOutDown animated'        => __('fadeOutDown','ultimate'),
			'fadeOutDownBig animated'     => __('fadeOutDownBig','ultimate'),
			'fadeOutLeft animated'        => __('fadeOutLeft','ultimate'),
			'fadeOutLeftBig animated'     => __('fadeOutLeftBig','ultimate'),
			'fadeOutRight animated'       => __('fadeOutRight','ultimate'),
			'fadeOutRightBig animated'    => __('fadeOutRightBig','ultimate'),
			'fadeOutUp animated'          => __('fadeOutUp','ultimate'),
			'fadeOutUpBig animated'       => __('fadeOutUpBig','ultimate'),
			'flip animated'               => __('flip','ultimate'),
			'flipInX animated'            => __('flipInX','ultimate'),
			'flipInY animated'            => __('flipInY','ultimate'),
			'flipOutX animated'           => __('flipOutX','ultimate'),
			'flipOutY animated'           => __('flipOutY','ultimate'),
			'lightSpeedIn animated'       => __('lightSpeedIn','ultimate'),
			'lightSpeedOut animated'      => __('lightSpeedOut','ultimate'),
			'rotateIn animated'           => __('rotateIn','ultimate'),
			'rotateInDownLeft animated'   => __('rotateInDownLeft','ultimate'),
			'rotateInDownRight animated'  => __('rotateInDownRight','ultimate'),
			'rotateInUpLeft animated'     => __('rotateInUpLeft','ultimate'),
			'rotateInUpRight animated'    => __('rotateInUpRight','ultimate'),
			'rotateOut animated'          => __('rotateOut','ultimate'),
			'rotateOutDownLeft animated'  => __('rotateOutDownLeft','ultimate'),
			'rotateOutDownRight animated' => __('rotateOutDownRight','ultimate'),
			'rotateOutUpLeft animated'    => __('rotateOutUpLeft','ultimate'),
			'rotateOutUpRight animated'   => __('rotateOutUpRight','ultimate'),
			'hinge animated'              => __('hinge','ultimate'),
			'jackInTheBox animated'       => __('jackInTheBox','ultimate'),
			'rollIn animated'             => __('rollIn','ultimate'),
			'rollOut animated'            => __('rollOut','ultimate'),
			'zoomIn animated'             => __('zoomIn','ultimate'),
			'zoomInDown animated'         => __('zoomInDown','ultimate'),
			'zoomInLeft animated'         => __('zoomInLeft','ultimate'),
			'zoomInRight animated'        => __('zoomInRight','ultimate'),
			'zoomInUp animated'           => __('zoomInUp','ultimate'),
			'zoomOut animated'            => __('zoomOut','ultimate'),
			'zoomOutDown animated'        => __('zoomOutDown','ultimate'),
			'zoomOutLeft animated'        => __('zoomOutLeft','ultimate'),
			'zoomOutRight animated'       => __('zoomOutRight','ultimate'),
			'zoomOutUp animated'          => __('zoomOutUp','ultimate'),
			'slideInDown animated'        => __('slideInDown','ultimate'),
			'slideInLeft animated'        => __('slideInLeft','ultimate'),
			'slideInRight animated'       => __('slideInRight','ultimate'),
			'slideInUp animated'          => __('slideInUp','ultimate'),
			'slideOutDown animated'       => __('slideOutDown','ultimate'),
			'slideOutLeft animated'       => __('slideOutLeft','ultimate'),
			'slideOutRight animated'      => __('slideOutRight','ultimate'),
			'slideOutUp animated'         => __('slideOutUp','ultimate'),
		];
	}

	protected function register_controls() {

		/******************************
		 * 	CONTENT SECTION
		 ******************************/
		$this->start_controls_section(
			'content_section',
			[
				'label' => __( 'Content', 'ultimate' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);

			// Icon Type
			$this->add_control(
				'postion_element_type',
				[
					'label'   => __( 'Element Type', 'ultimate' ),
					'type'    => Controls_Manager::SELECT,
					'default' => 'postion_element_font_or_svg_icon',
					'options' => [
						'postion_element_font_or_svg_icon' => __( 'Font Icon / SVG', 'ultimate' ),
						'postion_element_image'            => __( 'Image Icon / Image', 'ultimate' ),
						'postion_element_text'             => __( 'Simple Text', 'ultimate' ),
						'postion_element_shape'            => __( 'Blank Shape', 'ultimate' ),
					],
				]
			);

			// Font Icon
			$this->add_control(
				'postion_element_font_or_svg_icon',
				[
					'label'       => __( 'Font Icons', 'ultimate' ),
					'type'        => Controls_Manager::ICONS,
					'label_block' => true,
					'default'     => [
						'value'   => 'fas fa-star',
						'library' => 'solid',
					],
					'condition' => [
						'postion_element_type' => 'postion_element_font_or_svg_icon',
					],
				]
			);

			// Image Icon
			$this->add_control(
				'postion_element_image',
				[
					'label'   => __( 'Image Icon / Image', 'ultimate' ),
					'type'    => Controls_Manager::MEDIA,
					'default' => [
						'url' => Utils::get_placeholder_image_src(),
					],
					'condition' => [
						'postion_element_type' => 'postion_element_image',
					],
				]
			);

			// Image size
			$this->add_group_control(
				Group_Control_Image_Size:: get_type(),
				[
					'name'      => 'postion_element_image_size',
					'default'   => 'thumbnail',
					'condition' => [
						'postion_element_type' => 'postion_element_image',
					],
				]
			);

			// Title
			$this->add_control(
				'title',
				[
					'label'       => __( 'Text', 'ultimate' ),
					'type'        => Controls_Manager::TEXT,
					'placeholder' => __( 'Title', 'ultimate' ),
					'condition'   => [
						'postion_element_type' => 'postion_element_text',
					],
				]
			);

			// Animation
			$this->add_control(
				'element_animation',
				[
					'label'   => __( 'Element Animation', 'ultimate' ),
					'type'    => Controls_Manager::SELECT,
					'default' => 'no',
					'options' => [
						'yes' => __( 'Yes', 'ultimate' ),
						'no'  => __( 'No', 'ultimate' ),
					],
				]
			);

			// Custom Animate
			$this->add_control(
				'element_animation_type',
				[
					'label'     => __( 'Custom Animate Type', 'ultimate' ),
					'type'      => Controls_Manager::SELECT,
					'default'   => 'fadeIn',
					'options'   => self::get_animation_style(),
					'condition' => [
						'element_animation' => 'yes',
					]
				]
			);

			// Speed
			$this->add_control(
				'element_animation_speed',
				[
					'label'   => __( 'Animation Speed', 'ultimate' ),
					'type'    => Controls_Manager::SELECT,
					'default' => 'no',
					'options' => [
						'fast'   => __( 'Fast', 'ultimate' ),
						'faster' => __( 'Faster', 'ultimate' ),
						'slow'   => __( 'Slow', 'ultimate' ),
						'slower' => __( 'Slower', 'ultimate' ),
					],
					'condition' => [
						'element_animation' => 'yes',
					]
				]
			);

			// Infinite
			$this->add_control(
				'element_animation_infinite',
				[
					'label'   => __( 'Infine Animation', 'ultimate' ),
					'type'    => Controls_Manager::SELECT,
					'default' => 'no',
					'options' => [
						'infinite' => __( 'Yes', 'ultimate' ),
						'normal'   => __( 'No', 'ultimate' ),
					],
					'condition' => [
						'element_animation' => 'yes',
					]
				]
			);

			// Mode
			$this->add_control(
				'element_animation_direction',
				[
					'label'   => __( 'Animation Direction', 'ultimate' ),
					'type'    => Controls_Manager::SELECT,
					'default' => 'normal',
					'options' => [
						'normal'            => __( 'Normal', 'ultimate' ),
						'alternate'         => __( 'Alternate', 'ultimate' ),
						'reverse'           => __( 'Reverse', 'ultimate' ),
						'alternate-reverse' => __( 'Alternate Reverse', 'ultimate' ),
					],
					'condition' => [
						'element_animation' => 'yes',
					],
					'selectors' => [
						'{{WRAPPER}} .posiion__element__wrap' => '-webkit-animation-direction: {{VALUE}};  animation-direction: {{VALUE}};',
					],
				]
			);

			// Mode
			$this->add_control(
				'element_animation_custom_speed',
				[
					'label' => __( 'Animation Custom Duration', 'ultimate' ),
					'type'  => Controls_Manager::SLIDER,
					'range' => [
						'px' => [
							'min'  => 0.5,
							'max'  => 100,
							'step' => 0.5,
						],
					],
					'default' => [
						'size' => 1,
					],
					'selectors' => [
						'{{WRAPPER}} .posiion__element__wrap' => '-webkit-animation-duration: {{SIZE}}s;  animation-duration: {{SIZE}}s;',
					],
					'condition' => [
						'element_animation' => 'yes',
					]
				]
			);

		$this->end_controls_section();

		/*********************************
		 * 		STYLE SECTION
		 *********************************/

		/*----------------------------
			ELEMENT STYLE
		-----------------------------*/
		$this->start_controls_section(
			'element_style_section',
			[
				'label' => __( 'Position Element', 'ultimate' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

			/* $this->add_responsive_control(
				'_element_width',
				[
					'label'   => __( 'Width', 'ultimate' ),
					'type'    => Controls_Manager::SELECT,
					'default' => 'auto',
					'options' => [
						''        => __( 'Default', 'ultimate' ),
						'inherit' => __( 'Full Width', 'ultimate' ) . ' (100%)',
						'auto'    => __( 'Inline', 'ultimate' ) . ' (auto)',
						'initial' => __( 'Custom', 'ultimate' ),
					],
					'selectors_dictionary' => [
						'inherit' => '100%',
					],
					'prefix_class' => 'elementor-widget%s__width-',
					'selectors'    => [
						'{{WRAPPER}}' => 'width: {{VALUE}}; max-width: {{VALUE}}',
					],
				]
			);

			$this->add_responsive_control(
				'_element_custom_width',
				[
					'label' => __( 'Custom Width', 'ultimate' ),
					'type'  => Controls_Manager::SLIDER,
					'range' => [
						'px' => [
							'max'  => 1000,
							'step' => 1,
						],
						'%' => [
							'max'  => 100,
							'step' => 1,
						],
					],
					'condition' => [
						'_element_width' => 'initial',
					],
					'device_args' => [
						Controls_Stack::RESPONSIVE_TABLET => [
							'condition' => [
								'_element_width_tablet' => [ 'initial' ],
							],
						],
						Controls_Stack::RESPONSIVE_MOBILE => [
							'condition' => [
								'_element_width_mobile' => [ 'initial' ],
							],
						],
					],
					'size_units' => [ 'px', '%', 'vw' ],
					'selectors'  => [
						'{{WRAPPER}}' => 'width: {{SIZE}}{{UNIT}}; max-width: {{SIZE}}{{UNIT}}',
					],
				]
			);

			$this->add_responsive_control(
				'_element_vertical_align',
				[
					'label'   => __( 'Vertical Align', 'ultimate' ),
					'type'    => Controls_Manager::CHOOSE,
					'options' => [
						'flex-start' => [
							'title' => __( 'Start', 'ultimate' ),
							'icon'  => 'eicon-v-align-top',
						],
						'center' => [
							'title' => __( 'Center', 'ultimate' ),
							'icon'  => 'eicon-v-align-middle',
						],
						'flex-end' => [
							'title' => __( 'End', 'ultimate' ),
							'icon'  => 'eicon-v-align-bottom',
						],
					],
					'condition' => [
						'_element_width!' => '',
						'_position'       => '',
					],
					'selectors' => [
						'{{WRAPPER}}' => 'align-self: {{VALUE}}',
					],
					'separator' => 'before',
				]
			);

			$this->add_control(
				'_position_description',
				[
					'raw'             => '<strong>' . __( 'Please note!', 'ultimate' ) . '</strong> ' . __( 'Custom positioning is not considered best practice for responsive web design and should not be used too frequently.', 'ultimate' ),
					'type'            => Controls_Manager::RAW_HTML,
					'content_classes' => 'elementor-panel-alert elementor-panel-alert-warning',
					'render_type'     => 'ui',
					'condition'       => [
						'_position!' => '',
					],
					'separator' => 'before',
				]
			);

			$this->add_control(
				'_position',
				[
					'label'   => __( 'Position', 'ultimate' ),
					'type'    => Controls_Manager::SELECT,
					'default' => '',
					'options' => [
						''         => __( 'Default', 'ultimate' ),
						'absolute' => __( 'Absolute', 'ultimate' ),
						'relative' => __( 'Relative', 'ultimate' ),
						'fixed'    => __( 'Fixed', 'ultimate' ),
					],
					'prefix_class'       => 'elementor-',
					'frontend_available' => true,
					'separator'          => 'before',
				]
			);

			$start = is_rtl() ? __( 'Right', 'ultimate' ) : __( 'Left', 'ultimate' );
			$end   = ! is_rtl() ? __( 'Right', 'ultimate' ) : __( 'Left', 'ultimate' );

			$this->add_control(
				'_offset_orientation_h',
				[
					'label'   => __( 'Horizontal Orientation', 'ultimate' ),
					'type'    => Controls_Manager::CHOOSE,
					'toggle'  => false,
					'default' => 'start',
					'options' => [
						'start' => [
							'title' => $start,
							'icon'  => 'eicon-h-align-left',
						],
						'end' => [
							'title' => $end,
							'icon'  => 'eicon-h-align-right',
						],
					],
					'classes'     => 'elementor-control-start-end',
					'render_type' => 'ui',
					'condition'   => [
						'_position!' => '',
					],
					'separator' => 'before',
				]
			);

			$this->add_responsive_control(
				'_offset_x',
				[
					'label' => __( 'Offset', 'ultimate' ),
					'type'  => Controls_Manager::SLIDER,
					'range' => [
						'px' => [
							'min'  => -1000,
							'max'  => 1000,
							'step' => 1,
						],
						'%' => [
							'min' => -200,
							'max' => 200,
						],
						'vw' => [
							'min' => -200,
							'max' => 200,
						],
						'vh' => [
							'min' => -200,
							'max' => 200,
						],
					],
					'default' => [
						'size' => '0',
					],
					'size_units' => [ 'px', '%', 'vw', 'vh' ],
					'selectors'  => [
						'body:not(.rtl) {{WRAPPER}}' => 'left: {{SIZE}}{{UNIT}}',
						'body.rtl {{WRAPPER}}'       => 'right: {{SIZE}}{{UNIT}}',
					],
					'condition' => [
						'_offset_orientation_h!' => 'end',
						'_position!'             => '',
					],
				]
			);

			$this->add_responsive_control(
				'_offset_x_end',
				[
					'label' => __( 'Offset', 'ultimate' ),
					'type'  => Controls_Manager::SLIDER,
					'range' => [
						'px' => [
							'min'  => -1000,
							'max'  => 1000,
							'step' => 0.1,
						],
						'%' => [
							'min' => -200,
							'max' => 200,
						],
						'vw' => [
							'min' => -200,
							'max' => 200,
						],
						'vh' => [
							'min' => -200,
							'max' => 200,
						],
					],
					'default' => [
						'size' => '0',
					],
					'size_units' => [ 'px', '%', 'vw', 'vh' ],
					'selectors'  => [
						'body:not(.rtl) {{WRAPPER}}' => 'right: {{SIZE}}{{UNIT}}',
						'body.rtl {{WRAPPER}}'       => 'left: {{SIZE}}{{UNIT}}',
					],
					'condition' => [
						'_offset_orientation_h' => 'end',
						'_position!'            => '',
					],
				]
			);

			$this->add_control(
				'_offset_orientation_v',
				[
					'label'   => __( 'Vertical Orientation', 'ultimate' ),
					'type'    => Controls_Manager::CHOOSE,
					'toggle'  => false,
					'default' => 'start',
					'options' => [
						'start' => [
							'title' => __( 'Top', 'ultimate' ),
							'icon'  => 'eicon-v-align-top',
						],
						'end' => [
							'title' => __( 'Bottom', 'ultimate' ),
							'icon'  => 'eicon-v-align-bottom',
						],
					],
					'render_type' => 'ui',
					'condition'   => [
						'_position!' => '',
					],
					'separator' => 'before',
				]
			);

			$this->add_responsive_control(
				'_offset_y',
				[
					'label' => __( 'Offset', 'ultimate' ),
					'type'  => Controls_Manager::SLIDER,
					'range' => [
						'px' => [
							'min'  => -1000,
							'max'  => 1000,
							'step' => 1,
						],
						'%' => [
							'min' => -200,
							'max' => 200,
						],
						'vh' => [
							'min' => -200,
							'max' => 200,
						],
						'vw' => [
							'min' => -200,
							'max' => 200,
						],
					],
					'size_units' => [ 'px', '%', 'vh', 'vw' ],
					'default'    => [
						'size' => '0',
					],
					'selectors' => [
						'{{WRAPPER}}' => 'top: {{SIZE}}{{UNIT}}',
					],
					'condition' => [
						'_offset_orientation_v!' => 'end',
						'_position!'             => '',
					],
				]
			);

			$this->add_responsive_control(
				'_offset_y_end',
				[
					'label' => __( 'Offset', 'ultimate' ),
					'type'  => Controls_Manager::SLIDER,
					'range' => [
						'px' => [
							'min'  => -1000,
							'max'  => 1000,
							'step' => 1,
						],
						'%' => [
							'min' => -200,
							'max' => 200,
						],
						'vh' => [
							'min' => -200,
							'max' => 200,
						],
						'vw' => [
							'min' => -200,
							'max' => 200,
						],
					],
					'size_units' => [ 'px', '%', 'vh', 'vw' ],
					'default'    => [
						'size' => '0',
					],
					'selectors' => [
						'{{WRAPPER}}' => 'bottom: {{SIZE}}{{UNIT}}',
					],
					'condition' => [
						'_offset_orientation_v' => 'end',
						'_position!'            => '',
					],
				]
			); */



			$this->add_responsive_control(
				'postion_element_width',
				[
					'label'      => __( 'Element Fixed Width', 'ultimate' ),
					'type'       => Controls_Manager::SLIDER,
					'size_units' => [ 'px','vw','%' ],
					'range'      => [
						'px' => [
							'min'  => 0,
							'max'  => 1000,
							'step' => 1,
						],
						'vw' => [
							'min'  => -100,
							'max'  => 100,
							'step' => 1,
						],
						'%' => [
							'min' => 0,
							'max' => 100,
						],
					],
					'default' => [
						'unit' => 'px',
					],
					'selectors' => [
						'{{WRAPPER}}' => 'width: {{SIZE}}{{UNIT}};',
					],
					'separator' => 'before',
				]
			);

			$this->add_responsive_control(
				'postion_element_height',
				[
					'label'      => __( 'Element Fixed Height', 'ultimate' ),
					'type'       => Controls_Manager::SLIDER,
					'size_units' => [ 'px', '%' ],
					'range'      => [
						'px' => [
							'min'  => 0,
							'max'  => 1000,
							'step' => 1,
						],
						'%' => [
							'min' => 0,
							'max' => 100,
						],
					],
					'default' => [
						'unit' => 'px',
					],
					'selectors' => [
						'{{WRAPPER}}' => 'height: {{SIZE}}{{UNIT}};',
					],
				]
			);

			$this->add_responsive_control(
				'warapper_width',
				[
					'label'      => __( 'Content Warapper Width', 'ultimate' ),
					'type'       => Controls_Manager::SLIDER,
					'size_units' => [ 'px', '%', 'vw' ],
					'range'      => [
						'px' => [
							'min'  => 0,
							'max'  => 2000,
							'step' => 1,
						],
						'%' => [
							'min'  => 0,
							'max'  => 100,
							'step' => 1,
						],
						'vw' => [
							'min'  => 0,
							'max'  => 100,
							'step' => 1,
						],
					],
					'default' => [
						'unit' => 'px',
					],
					'selectors' => [
						'{{WRAPPER}} .posiion__element__item' => 'width: {{SIZE}}{{UNIT}};',
					],
					'separator' => 'before',
				]
			);

			$this->add_responsive_control(
				'warapper_height',
				[
					'label'      => __( 'Content Warapper Height', 'ultimate' ),
					'type'       => Controls_Manager::SLIDER,
					'size_units' => [ 'px', '%', 'vw' ],
					'range'      => [
						'px' => [
							'min'  => 0,
							'max'  => 2000,
							'step' => 1,
						],
						'%' => [
							'min'  => 0,
							'max'  => 100,
							'step' => 1,
						],
						'vw' => [
							'min'  => 0,
							'max'  => 100,
							'step' => 1,
						],
					],
					'default' => [
						'unit' => 'px',
					],
					'selectors' => [
						'{{WRAPPER}} .posiion__element__item' => 'height: {{SIZE}}{{UNIT}};',
					],
				]
			);

			$this->add_responsive_control(
				'postion_element_image_size_width',
				[
					'label'      => __( 'Image Width', 'ultimate' ),
					'type'       => Controls_Manager::SLIDER,
					'size_units' => [ 'px', '%' ],
					'range'      => [
						'px' => [
							'min'  => 0,
							'max'  => 1000,
							'step' => 1,
						],
						'%' => [
							'min' => 0,
							'max' => 100,
						],
					],
					'default' => [
						'unit' => 'px',
					],
					'selectors' => [
						'{{WRAPPER}} img' => 'width: {{SIZE}}{{UNIT}};',
					],
					'condition' => [
						'postion_element_type' => ['postion_element_image']
					],
					'separator' => 'before',
				]
			);

			$this->add_responsive_control(
				'postion_element_image_size_height',
				[
					'label'      => __( 'Image Height', 'ultimate' ),
					'type'       => Controls_Manager::SLIDER,
					'size_units' => [ 'px', '%' ],
					'range'      => [
						'px' => [
							'min'  => 0,
							'max'  => 1000,
							'step' => 1,
						],
						'%' => [
							'min' => 0,
							'max' => 100,
						],
					],
					'default' => [
						'unit' => 'px',
					],
					'selectors' => [
						'{{WRAPPER}} img' => 'width: {{SIZE}}{{UNIT}};',
					],
					'condition' => [
						'postion_element_type' => ['postion_element_image']
					],
				]
			);

			$this->add_group_control(
				Group_Control_Css_Filter:: get_type(),
				[
					'name'      => 'position_element_image_filters',
					'label'     => __( 'Image Filter', 'ultimate' ),
					'selector'  => '{{WRAPPER}} img',
					'condition' => [
						'postion_element_type' => ['postion_element_image']
					],
					'separator' => 'before',
				]
			);

			$this->add_control(
				'position_element_color',
				[
					'label'     => __( 'Color', 'ultimate' ),
					'type'      => Controls_Manager::COLOR,
					'default'   => '',
					'selectors' => [
						'{{WRAPPER}} .posiion__element__item' => 'color: {{VALUE}};',
					],
					'separator' => 'before',
				]
			);

			$this->add_group_control(
				Group_Control_Typography:: get_type(),
				[
					'name'      => 'position_element_typography',
					'selector'  => '{{WRAPPER}} .posiion__element__item',
					'condition' => [
						'postion_element_type' => ['postion_element_font_or_svg_icon','postion_element_text']
					],
				]
			);

			$this->add_group_control(
				Group_Control_Background:: get_type(),
				[
					'name'     => 'position_element_background',
					'label'    => __( 'Background', 'ultimate' ),
					'types'    => [ 'classic', 'gradient' ],
					'selector' => '{{WRAPPER}} .posiion__element__item',
				]
			);

			$this->add_group_control(
				Group_Control_Border:: get_type(),
				[
					'name'      => 'position_element_border',
					'label'     => __( 'Border', 'ultimate' ),
					'selector'  => '{{WRAPPER}} .posiion__element__item',
					'separator' => 'before',
				]
			);

			$this->add_responsive_control(
				'position_element_radius',
				[
					'label'      => __( 'Border Radius', 'ultimate' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .posiion__element__item, {{WRAPPER}} .posiion__element__item img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			
			$this->add_group_control(
				Group_Control_Box_Shadow:: get_type(),
				[
					'name'     => 'position_element_shadow',
					'selector' => '{{WRAPPER}} .posiion__element__item',
				]
			);
			
			$this->add_responsive_control(
				'position_element_display',
				[
					'label'   => __( 'Display', 'ultimate' ),
					'type'    => Controls_Manager::SELECT,
					'default' => 'inline-block',
					'options' => [
						'initial'      => __( 'Initial', 'ultimate' ),
						'block'        => __( 'Block', 'ultimate' ),
						'inline-block' => __( 'Inline Block', 'ultimate' ),
						'flex'         => __( 'Flex', 'ultimate' ),
						'inline-flex'  => __( 'Inline Flex', 'ultimate' ),
						'none'         => __( 'none', 'ultimate' ),
					],
					'selectors' => [
						'{{WRAPPER}}' => 'display: {{VALUE}};',
					],
					'separator' => 'before',
				]
			);

			$this->add_responsive_control(
				'position_element_align',
				[
					'label'   => __( 'Alignment', 'ultimate' ),
					'type'    => Controls_Manager::CHOOSE,
					'options' => [
						'left' => [
							'title' => __( 'Left', 'ultimate' ),
							'icon'  => 'fa fa-align-left',
						],
						'center' => [
							'title' => __( 'Center', 'ultimate' ),
							'icon'  => 'fa fa-align-center',
						],
						'right' => [
							'title' => __( 'Right', 'ultimate' ),
							'icon'  => 'fa fa-align-right',
						],
						'justify' => [
							'title' => __( 'Justify', 'ultimate' ),
							'icon'  => 'fa fa-align-justify',
						],
					],
					'selectors' => [
						'{{WRAPPER}}' => 'text-align: {{VALUE}};',
					],
					'separator' => 'before',
				]
			);

			$this->add_control(
				'position_element_zindex',
				[
					'label'     => __( 'Z-Index', 'ultimate' ),
					'type'      => Controls_Manager::NUMBER,
					'min'       => -99,
					'max'       => 99,
					'step'      => 1,
					'selectors' => [
						'{{WRAPPER}}' => 'z-index: {{SIZE}};',
					],
					'separator' => 'before',
				]
			);

			$this->add_control(
				'position_element_opacity',
				[
					'label' => __( 'Opacity', 'ultimate' ),
					'type'  => Controls_Manager::SLIDER,
					'range' => [
						'px' => [
							'max'  => 1,
							'min'  => 0.10,
							'step' => 0.01,
						],
					],
					'selectors' => [
						'{{WRAPPER}}' => 'opacity: {{SIZE}};',
					],
					'separator' => 'before',
				]
			);

			$this->add_responsive_control(
				'postion_elemnent_margin',
				[
					'label'      => __( 'Margin', 'ultimate' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .posiion__element__item' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
					'separator' => 'before',
				]
			);

			$this->add_responsive_control(
				'postion_elemnent_padding',
				[
					'label'      => __( 'Padding', 'ultimate' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .posiion__element__item' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);

		$this->end_controls_section();
		/*----------------------------
			ICON STYLE END
		-----------------------------*/		
	}
	
	protected function render() {

		$settings = $this->get_settings_for_display();

		$this->add_render_attribute( 'posiion__element__wrap_attr', 'class', 'posiion__element__wrap' );
		$this->add_render_attribute( 'posiion__element__wrap_attr', 'class', $settings['element_animation_type'] );
		$this->add_render_attribute( 'posiion__element__wrap_attr', 'class', $settings['element_animation_infinite'] );
		$this->add_render_attribute( 'posiion__element__wrap_attr', 'class', $settings['element_animation_speed'] );
		$this->add_render_attribute( 'posiion__element__wrap_attr', 'class', $settings['element_animation_infinite'] );

		// Icon Condition
		if ( 'postion_element_font_or_svg_icon' == $settings['postion_element_type'] && !empty( $settings['postion_element_font_or_svg_icon'] ) ) {
			$element = '<div class="posiion__element__item">'.ultimate_render_icons( $settings['postion_element_font_or_svg_icon'] ).'</div>';
		}elseif( 'postion_element_image' == $settings['postion_element_type'] && !empty( $settings['postion_element_image'] ) ){
			$element_array = $settings['postion_element_image'];
			$element_link  = wp_get_attachment_image_url( $element_array['id'], 'thumbnail' );
			$image         = Group_Control_Image_Size::get_attachment_image_html( $settings, 'postion_element_image_size', 'postion_element_image');
			$element       = '<div class="posiion__element__item">'.$image.'</div>';
		}elseif ( 'postion_element_text' == $settings['postion_element_type'] && !empty( $settings['title'] ) ) {
			$element = '<div class="posiion__element__item">'.esc_html( $settings['title'] ).'</div>';
		}elseif ( 'postion_element_shape' == $settings['postion_element_type'] ) {
			$element = '<div class="posiion__element__item"></div>';
		}else{
			$element = '';
		}

		echo '<div '.$this->get_render_attribute_string('posiion__element__wrap_attr').'>
				'.( isset( $element ) ? $element : '' ).'
			</div>';

	}

	protected function content_template() {}
}
Plugin::instance()->widgets_manager->register( new Ultimate_Positions_Element() );