<?php

$info       = wp_get_theme();
$author     = $info->get( 'Author' );    
$author_uri = $info->get( 'AuthorURI' );
$author_uri = '<a target="_blank" href="'. esc_url( $author_uri ) .'">'. esc_html( $author ) .'</a>';

/*-----------------------------------
    FOOTER TOP SECTION
------------------------------------*/
CSF::createSection( UTECH_OPTION_KEY,
    array(
        'parent' => 'Footer_Tab',
        'title'  => esc_html__( 'Footer Copyright', 'utech' ),
        'icon'   => 'fa fa-copyright',
        'fields' => array(
            array(
                'type'    => 'subheading',
                'content' => esc_html__( 'Footer Copyright Text', 'utech' ),
            ),
            array(
                'id'            => 'copyright_text',
                'type'          => 'wp_editor',
                'title'         => esc_html__( 'Copyright Text', 'utech' ),
                'desc'          => esc_html__( 'Set the footer copyright text. Use {YEAR} for showing year dynamically and use &copy; or {COPYRIGHT} for getting dynamically copyright sign.','utech' ),
                'tinymce'       => true,
                'quicktags'     => true,
                'media_buttons' => false,
                'height'        => '200px',
                'default'       => sprintf( __( 'Copyright {COPYRIGHT} %s {YEAR} All Right Reserved.', 'utech' ), $author_uri ),
            ),
        ),
    )
);