<?php
/**
 * Register widget area.
 *
 * @link https://developer.wordpress.org/themes/functionality/sidebars/#registering-a-sidebar
 */
function utech_widgets_init() {
	register_sidebar( array(
		'name'          => esc_html__( 'Blog Sidebar', 'utech' ),
		'id'            => 'main-sidebar',
		'description'   => esc_html__( 'Add widgets here.', 'utech' ),
		'before_widget' => '<div id="%1$s" class="single-widgets %2$s">',
		'after_widget'  => '</div>',
		'before_title'  => '<div class="widget-title"><h3>',
		'after_title'   => '</h3></div>',
	) );

	register_sidebar( array(
		'name'          => esc_html__( 'Header Sidebar', 'utech' ),
		'id'            => 'header-sidebar',
		'description'   => esc_html__( 'Add widgets here.', 'utech' ),
		'before_widget' => '<div id="%1$s" class="single-widgets %2$s">',
		'after_widget'  => '</div>',
		'before_title'  => '<div class="widget-title"><h3>',
		'after_title'   => '</h3></div>',
	) );

	$footer_widget_one = array( 'one', 'two', 'three', 'five', 'six', 'seven', 'four', 'eight', 'nine' );
	if ( in_array( utech_get_option( 'footer_top_columns', 'four' ), $footer_widget_one ) ) {
		register_sidebar( array(
			'name'          => esc_html__( 'Footer Sidebar 1', 'utech' ),
			'id'            => 'footer-sidebar-1',
			'description'   => esc_html__( 'Add footer widgets here.', 'utech' ),
			'before_widget' => '<div id="%1$s" class="single-widgets %2$s">',
			'after_widget'  => '</div>',
			'before_title'  => '<h3 class="widget-title">',
			'after_title'   => '</h3>',
		) );
	}

	$footer_widget_two = array( 'two', 'three', 'five', 'six', 'seven', 'four', 'eight', 'nine' );
	if ( in_array( utech_get_option( 'footer_top_columns', 'four' ), $footer_widget_two ) ) {
		register_sidebar( array(
			'name'          => esc_html__( 'Footer Sidebar 2', 'utech' ),
			'id'            => 'footer-sidebar-2',
			'description'   => esc_html__( 'Add footer widgets here.', 'utech' ),
			'before_widget' => '<div id="%1$s" class="single-widgets %2$s">',
			'after_widget'  => '</div>',
			'before_title'  => '<h3 class="widget-title">',
			'after_title'   => '</h3>',
		) );
	}

	$footer_widget_three = array( 'three', 'five', 'six', 'seven', 'four', 'eight', 'nine' );
	if ( in_array( utech_get_option( 'footer_top_columns', 'four' ), $footer_widget_three ) ) {
		register_sidebar( array(
			'name'          => esc_html__( 'Footer Sidebar 3', 'utech' ),
			'id'            => 'footer-sidebar-3',
			'description'   => esc_html__( 'Add footer widgets here.', 'utech' ),
			'before_widget' => '<div id="%1$s" class="single-widgets %2$s">',
			'after_widget'  => '</div>',
			'before_title'  => '<h3 class="widget-title">',
			'after_title'   => '</h3>',
		) );
	}

	$footer_widget_four = array( 'four', 'eight', 'nine' );
	if ( in_array( utech_get_option( 'footer_top_columns', 'four' ), $footer_widget_four ) ) {
		register_sidebar( array(
			'name'          => esc_html__( 'Footer Sidebar 4', 'utech' ),
			'id'            => 'footer-sidebar-4',
			'description'   => esc_html__( 'Add footer widgets here.', 'utech' ),
			'before_widget' => '<div id="%1$s" class="single-widgets %2$s">',
			'after_widget'  => '</div>',
			'before_title'  => '<h3 class="widget-title">',
			'after_title'   => '</h3>',
		) );
	}
}
add_action( 'widgets_init', 'utech_widgets_init' );