<?php

if ( !defined( 'FW' ) ) {
    return;
}

function utech_backups_demos( $demos ) {
	
	$preview_url = wp_get_theme()->get( 'ThemeURI' );
    $demo_content_source = $preview_url . '/content';

	$demos_array			 = array(

		'home_1'			 => array(
			'title'			 => esc_html__( 'uTech Demo Without WooCommerce', 'utech' ),
			'screenshot'	 => esc_url( $demo_content_source ) . '/screenshot.png',
			'preview_link'	 => esc_url( $preview_url ),
		),
		'home_2'			 => array(
			'title'			 => esc_html__( 'uTech Demo With WooCommerce', 'utech' ),
			'screenshot'	 => esc_url( $demo_content_source ) . '/screenshot.png',
			'preview_link'	 => esc_url( $preview_url ),
		),
		'home_3'			 => array(
			'title'			 => esc_html__( 'uTech Demo With ( One Page Versions )', 'utech' ),
			'screenshot'	 => esc_url( $demo_content_source ) . '/screenshot.png',
			'preview_link'	 => esc_url( $preview_url ),
		),
		'home_4'			 => array(
			'title'			 => esc_html__( 'uTech All Demo Content', 'utech' ),
			'screenshot'	 => esc_url( $demo_content_source ) . '/screenshot.png',
			'preview_link'	 => esc_url( $preview_url ),
		),
	);

	$download_url			 = esc_url( $demo_content_source ) . '/download.php';
	
	foreach ( $demos_array as $id => $data ) {
		$demo = new FW_Ext_Backups_Demo( $id, 'piecemeal', array(
			'url'		 => $download_url,
			'file_id'	 => $id,
		) );
		$demo->set_title( $data[ 'title' ] );
		$demo->set_screenshot( $data[ 'screenshot' ] );
		$demo->set_preview_link( $data[ 'preview_link' ] );
		$demos[ $demo->get_id() ]	 = $demo;
		unset( $demo );
	}

	return $demos;
}
add_filter( 'fw:ext:backups-demo:demos', 'utech_backups_demos' );