#!/bin/bash
# FIXME: workaround for bug https://cloudlinux.atlassian.net/browse/DEF-2271

if grep -q 'enable_scan_modsec:\s*true' /etc/sysconfig/imunify360/imunify360-merged.config; then
    out=($(/usr/share/imunify360/scripts/modsec_scan_real.py "$@"))
    echo "${out[@]}"
    # Script prints one of two possible lines:
    #   '1 OK' - when malware is not found in the file
    #   '0 Attempt to upload malware' - when malware has been found in the file
    # At the moment, Coraza does not handle script output properly:
    #   https://github.com/corazawaf/coraza/pull/1311
    # Thus we exit with code 1 to make Coraza pass the file and with code 0 to block the file.
    # The original modsec 2.x don't care about exit code either, so it should handle it fine.
    code=${out[0]}
    [[ "$code" =~ ^[0-9]+$ ]] || code=1
    exit $code
else
    echo "1 OK"
    exit 1
fi
