local domain_ip_file = "/etc/imunify360-webshield/default-destinations.dat"
local domains_ips = ngx.shared.domains_ips

local function split(string)
    local tokens = {}
    for token in string:gmatch("%S+") do
        table.insert(tokens, token)
    end
    return tokens
end

local function get_domain_ip_map()
    local f = io.open(domain_ip_file)
    if not f then
        return
    end

    for line in f:lines() do
        local rv = split(line)
        if table.getn(rv) == 2 then
            -- domain -> ip
            domains_ips:set(rv[1], rv[2])
        end
    end
end

get_domain_ip_map()
