local template = require 'resty.template'
local cookie = require 'resty.cookie'

local function set_captcha_cookie()
    local cookie_obj, err = cookie:new()
    if not cookie_obj then
        ngx.log(ngx.ERR, "Failed to init cookie: ", err)
        return
    end

    local current_timestamp = os.time()
    local offset = 3600              -- 1 hour
    local expiration_date = os.date(
        "!%a, %d-%b-%y %H:%M:%S GMT", current_timestamp + offset)

    local ok, err = cookie_obj:set({
        key = "cl-bypass-cache",
        value = "yes",
        domain = ngx.var.host,
        samesite = "Lax",
        httponly = true,
        path = "/",
        expires = expiration_date
    })
    if not ok then
        ngx.log(ngx.ERR, "Could not set cookie: ", err)
    end
end

local default_site_key = "6LfwghwUAAAAAAYrFATHtss0Xe_bC7I6OWE_ayK4"
local custom_site_key = ngx.var.wscaptcha_site_key
local captcha_site_key = custom_site_key or default_site_key
local vars = {
    invisible=ngx.var.invisible_captcha,
    captcha_key=captcha_site_key
}
set_captcha_cookie()
template.render('index.html', vars, 'captcha')
