<?php
if ( !class_exists('vidorev_submit_video_report_settings' ) ):
	class vidorev_submit_video_report_settings {
	
		private $settings_api;
	
		function __construct() {
			$this->settings_api = new WeDevs_Settings_API;
	
			add_action( 'admin_init', array($this, 'admin_init') );
			add_action( 'admin_menu', array($this, 'admin_menu') );
		}
	
		function admin_init() {
			$this->settings_api->set_sections( $this->get_settings_sections() );
			$this->settings_api->set_fields( $this->get_settings_fields() );

			$this->settings_api->admin_init();
		}
	
		function admin_menu() {
			add_submenu_page('edit.php?post_type=video_report_check', esc_html__( 'Video Report Settings', 'vidorev-extensions'), esc_html__( 'Video Report Settings', 'vidorev-extensions'), 'manage_options', 'vidorev_submit_video_report_settings', array($this, 'plugin_page') );
		}
	
		function get_settings_sections() {
			$sections = array(
				array(
					'id' 	=> 'submit_video_report_settings',
					'title' => esc_html__('Video Report Settings', 'vidorev-extensions')
				),				          
			);
			
			return $sections;
		}

		function get_settings_fields() {
			$settings_fields = array(
				'submit_video_report_settings' => array(
					array(
						'name'    => 'login',
						'label'   => esc_html__( 'Login Required to Report', 'vidorev-extensions'),
						'desc'    => esc_html__( 'Select whether only logged in users can report or not.', 'vidorev-extensions'),
						'type'    => 'select',
						'default' => 'yes',
						'options' => array(
							'yes'			=> esc_html__('YES', 'vidorev-extensions'),				
							'no'			=> esc_html__('NO', 'vidorev-extensions'),													
						)
					),			       
				),       
			);
	
			return $settings_fields;
		}
	
		function plugin_page() {
			echo '<div class="wrap">';
	
				$this->settings_api->show_navigation();
				$this->settings_api->show_forms();
	
			echo '</div>';
		}	
	}
endif;
new vidorev_submit_video_report_settings();

if(!function_exists('vidorev_submit_video_report')){
	function vidorev_submit_video_report(){
		
		$required_login = trim(vidorev_get_option('login', 'submit_video_report_settings', 'yes'));
		
		$wpNonceCheck = $required_login=='yes'?true:false;
		$is_user_logged_in = $required_login=='yes'?is_user_logged_in():true;
		
		$json_params = array();
		
		if(!$is_user_logged_in || !isset($_POST['post_id']) || !isset($_POST['reasons']) || !isset($_POST['security']) || !is_numeric($_POST['post_id']) || trim($_POST['security']) == '' || trim($_POST['reasons']) == ''){
			$json_params['error'] = 'yes';
			wp_send_json($json_params);
			return;
			die();
		}
		
		$theme_data = wp_get_theme();
		if(!vidorev_ajax_verify_nonce(trim($_POST['security']), $wpNonceCheck) /*!wp_verify_nonce(trim($_POST['security']), 'BeeTeam368-vidorev'.$theme_data->get( 'Version' ).$theme_data->get( 'Name' ).$wpNonceCheck )*/){
			$json_params['error'] = 'yes';
			wp_send_json($json_params);
			return;
			die();
		}
		
		if(is_user_logged_in()){
			$current_user 	= wp_get_current_user();
			$user_id 		= (int)$current_user->ID;		
		}else{
			$user_id		= 0;
		}
		$meta_id		= $_POST['post_id'].'|'.$user_id;
		
		$exists = new WP_Query(array(
			'post_type'   	=> 'video_report_check',
			'post_status' 	=> 'any',
			'posts_per_page'=> 1,			
			'meta_query'  	=> array(
				array(
					'key'     => 'post_report_id',
					'value'   => $meta_id,
					'compare' => '=',
				),
			),
		));

		if($exists->have_posts()){			
			wp_reset_postdata();			
			$json_params['error'] = 'already_exist';
			wp_send_json($json_params);			
			return;
			die();
		}
		
		wp_reset_postdata();
		
		$postData = array();											
		$postData['post_title'] 	= esc_html__('Report', 'vidorev-extensions').': '.get_the_title($_POST['post_id']);	
		$postData['post_status'] 	= 'publish';
		$postData['post_type'] 		= 'video_report_check';
		
		$newPostID = wp_insert_post($postData);
		
		if(!is_wp_error($newPostID) && $newPostID){			
			update_post_meta($newPostID, 'post_report_id', $meta_id);
			update_post_meta($newPostID, 'post_report_seasons', trim($_POST['reasons']));	
		}else{
			$json_params['error'] = 'yes';
			wp_send_json($json_params);
			return;
			die();
		}
		
		$json_params['success'] = 'yes';
		wp_send_json($json_params);
		
		die();
	}
}
add_action('wp_ajax_vidorev_submit_video_report', 'vidorev_submit_video_report');
add_action('wp_ajax_nopriv_vidorev_submit_video_report', 'vidorev_submit_video_report');	

if(!function_exists('vidorev_video_report_column_ID')){
	function vidorev_video_report_column_ID( $columns ) {
		$date = $columns['date'];
		unset($columns['date']);
		$columns['reasons'] = esc_html__('Reasons', 'vidorev-extensions');
		$columns['edit_view_data'] = esc_html__('Action', 'vidorev-extensions');
		$columns['user_report'] = esc_html__('User Report', 'vidorev-extensions');
		$columns['date'] = $date;
		return $columns;
	}
}
add_filter('manage_edit-video_report_check_columns', 'vidorev_video_report_column_ID');

if(!function_exists('vidorev_video_report_column_ID_value')){
	function vidorev_video_report_column_ID_value( $colname, $cptid ) {
		
		$explode_id = explode('|', get_post_meta($cptid, 'post_report_id', true));
		
		if ( $colname == 'reasons' ){
			echo '<code class="reasons-texxt">'.get_post_meta($cptid, 'post_report_seasons', true).'</code>';
		}elseif($colname == 'edit_view_data' ){
			if(is_array($explode_id) && count($explode_id) == 2){
				echo 	wp_kses(
							__('<a href="'.esc_url(get_edit_post_link($explode_id[0])).'" target="_blank">Edit Post</a> | <a href="'.esc_url(get_permalink($explode_id[0])).'" target="_blank">View Post</a>', 'vidorev-extensions'
							),
							array(
								'a'=>array('href' => array(), 'target' => array()),
							)
						);
			}
		}elseif($colname == 'user_report'){
			if(is_array($explode_id) && count($explode_id) == 2){
				if($explode_id[1] == 0){
					
					echo esc_html__('Unknown', 'vidorev-extensions');
								
				}else{
					$user_obj = get_user_by('id', $explode_id[1]);
					echo 	wp_kses(
								__('User Name: <strong>'.$user_obj->user_login.'</strong> | <a href="'.esc_url(get_edit_user_link($user_obj->ID)).'" target="_blank">View User</a>', 'vidorev-extensions'
								),
								array(
									'a'=>array('href' => array(), 'target' => array()),
									'strong'=>array(),
								)
							);
				}
			}
		}
	}
}
add_action('manage_video_report_check_posts_custom_column', 'vidorev_video_report_column_ID_value', 10, 2);

if(!function_exists('vidorev_get_report_items')){
	function vidorev_get_report_items( $post_type ) {
		global $wpdb;
		/*fake prepare*/
		$pending_count = $wpdb->get_var( $wpdb->prepare( "SELECT COUNT(*) FROM $wpdb->posts WHERE post_type IN( 'video_report_check' %s ) AND post_status = 'publish'", $post_type ) );
		/*fake prepare*/
		return (int) $pending_count;
	}
}

if(!function_exists('vidorev_notification_bubble_in_report_menu')){
	function vidorev_notification_bubble_in_report_menu() {
		global $menu;
		$pending_items = vidorev_get_report_items( ''/*fake prepare*/ );
		
		foreach ( $menu as $key => $value ){
			if ( $menu[$key][2] == 'edit.php?post_type=video_report_check' ){
				$menu[$key][0] .= $pending_items ? " <span class='update-plugins count-1' title='title'><span class='update-count'>$pending_items</span></span>" : '';
				return;
			}
		}
	}
}
add_action('admin_menu', 'vidorev_notification_bubble_in_report_menu');