<?php
if(!function_exists('vidorev_get_option')):
	function vidorev_get_option( $option, $section, $default = '' ) {
	
		$options = get_option( $section );
	
		if ( isset( $options[$option] ) ) {
			return $options[$option];
		}
	
		return $default;
	}
endif;

if(!function_exists('vidorev_get_redux_option')):
	function vidorev_get_redux_option( $id, $default_value = '', $type = NULL ){ //type string, switch ...
		
		global $vidorev_theme_options;
		
		if(isset($vidorev_theme_options) && is_array($vidorev_theme_options) && isset($vidorev_theme_options[$id]) && $vidorev_theme_options[$id]!=''){
			
			switch($type){
				case 'switch':					
					if($vidorev_theme_options[$id]==1){
						return 'on';
					}else{
						return 'off';
					}
					break;
					
				case 'media_get_src':
					if(is_array($vidorev_theme_options[$id]) && isset($vidorev_theme_options[$id]['url']) && $vidorev_theme_options[$id]['url']!=''){
						return trim($vidorev_theme_options[$id]['url']);
					}else{
						return $default_value;
					}
					break;
					
				case 'media_get_id':
					if(is_array($vidorev_theme_options[$id]) && isset($vidorev_theme_options[$id]['id']) && $vidorev_theme_options[$id]['id']!=''){
						return trim($vidorev_theme_options[$id]['id']);
					}else{
						return $default_value;
					}
					break;				
			}
			
			return $vidorev_theme_options[$id];
				
		}
		
		return $default_value;
	}
endif;

if ( ! function_exists( 'vidorev_ajax_verify_nonce' ) ) :
	function vidorev_ajax_verify_nonce($nonce, $login = true){
		
		$wp_nonce_ds = vidorev_get_redux_option('wp_nonce_ds', 'off', 'switch');
		
		if($wp_nonce_ds === 'off'){
			return true;
		}
		
		$theme_data = wp_get_theme();
		$require_login = $login?'true':var_export(is_user_logged_in(), true);
		if(!wp_verify_nonce(trim($nonce), 'BeeTeam368-vidorev'.$theme_data->get( 'Version' ).$theme_data->get( 'Name' ).$require_login )){
			return false;
		}
		
		return true;
	}
endif;