<?php
/**
 * Plugin Name: Bdexpert Cross Copy Paste
 * Description: Bdexpert Cross Copy Paster Context Menu For Elementor Page Builder.
 * Plugin URI: https://plugins.bdexpert.net/becrosscp
 * Author: BDEXPERT
 * Author URI: https://mehedidb.com
 * Version: 1.0.0
 * License: GPL2
 * Text Domain: becrosscp
 * Domain Path: domain/path
 */

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

if ( !class_exists( 'Be_Cross_Copy_Paste_Loader' ) ) {

    class Be_Cross_Copy_Paste_Loader {

        private static $_instance = null;

        const VERSION = "1.0.0";

        const MINIMUM_PHP_VERSION = '7.0';

        const MINIMUM_ELEMENTOR_VERSION = '3.0.0';

        public function __construct() {
            add_action( 'plugins_loaded', [$this, 'becrosscp_plugins_loaded'] );
            add_action( 'plugins_loaded', [$this, 'load_files'] );
        }

        // Initialize
        public function becrosscp_plugins_loaded() {

            // Check if Elementor installed and activated
            if ( !did_action( 'elementor/loaded' ) ) {
                add_action( 'admin_notices', array( $this, 'becrosscp_notice_missing_main_plugin' ) );
                return;
            }

            // Check for required Elementor version
            if ( !version_compare( ELEMENTOR_VERSION, self::MINIMUM_ELEMENTOR_VERSION, '>=' ) ) {
                add_action( 'admin_notices', array( $this, 'becrosscp_notice_minimum_elementor_version' ) );
                return;
            }

            // Check for required PHP version
            if ( version_compare( PHP_VERSION, self::MINIMUM_PHP_VERSION, '<' ) ) {
                add_action( 'admin_notices', array( $this, 'becrosscp_notice_minimum_php_version' ) );
                return;
            }

            $this->becrosscp_load_textdomain();
        }

        public function is_elementor_activated( $plugin_path = 'elementor/elementor.php' ) {
            $installed_plugins_list = get_plugins();
            return isset( $installed_plugins_list[$plugin_path] );
        }

        public function becrosscp_notice_missing_main_plugin() {
            $plugin = 'elementor/elementor.php';

            if ( $this->is_elementor_activated() ) {
                if ( !current_user_can( 'activate_plugins' ) ) {
                    return;
                }
                $activation_url = wp_nonce_url( 'plugins.php?action=activate&amp;plugin=' . $plugin . '&amp;plugin_status=all&amp;paged=1&amp;s', 'activate-plugin_' . $plugin );
                $message        = sprintf( esc_html__( 'Becrosscp requires %1$s"Elementor"%2$s plugin to be active. Please activate Elementor to continue.', 'becrosscp' ), '<strong>', '</strong>' );
                $button_text    = esc_html__( 'Activate Elementor', 'becrosscp' );
            } else {
                if ( !current_user_can( 'install_plugins' ) ) {
                    return;
                }

                $activation_url = wp_nonce_url(
                    self_admin_url( 'update.php?action=install-plugin&plugin=elementor' ),
                    'install-plugin_elementor'
                );

                $message     = sprintf( esc_html__( 'Becrosscp requires %1$s"Elementor"%2$s plugin to be installed and activated. Please install Elementor to continue.', 'becrosscp' ), '<strong>', '</strong>' );
                $button_text = esc_html__( 'Install Elementor', 'becrosscp' );

            }

            $button = '<p><a href="' . esc_url_raw( $activation_url ) . '" class="button-primary">' . esc_html( $button_text ) . '</a></p>';

            printf( '<div class="notice notice-warning is-dismissible"><p>%1$s</p>%2$s</div>', $message, $button );
        }

        public function becrosscp_notice_minimum_elementor_version() {
            if ( isset( $_GET['activate'] ) ) {
                unset( $_GET['activate'] );
            }

            $message = sprintf(
                /* translators: 1: Plugin name 2: Elementor 3: Required Elementor version */
                esc_html__( '"%1$s" requires "%2$s" version %3$s or greater.', 'becrosscp' ),
                '<strong>' . esc_html__(
                    'Becrosscp',
                    'becrosscp'
                ) . '</strong>',
                '<strong>' . esc_html__( 'Elementor', 'becrosscp' ) . '</strong>',
                self::MINIMUM_ELEMENTOR_VERSION
            );

            printf( '<div class="notice notice-warning is-dismissible"><p>%1$s</p></div>', $message );
        }

        public function becrosscp_notice_minimum_php_version() {
            if ( isset( $_GET['activate'] ) ) {
                unset( $_GET['activate'] );
            }

            $message = sprintf(
                /* translators: 1: Plugin name 2: PHP 3: Required PHP version */
                esc_html__( '"%1$s" requires "%2$s" version %3$s or greater.', 'becrosscp' ),
                '<strong>' . esc_html__(
                    'Becrosscp',
                    'becrosscp'
                ) . '</strong>',
                '<strong>' . esc_html__( 'PHP', 'becrosscp' ) . '</strong>',
                self::MINIMUM_PHP_VERSION
            );

            printf( '<div class="notice notice-warning is-dismissible"><p>%1$s</p></div>', $message );
        }

        public function becrosscp_helper (){
        }
        
        public function load_files() {
            
            require dirname( __FILE__ ) . '/inc/helper.php';
            require dirname( __FILE__ ) . '/inc/class.ixporter.php';
            require dirname( __FILE__ ) . '/inc/class.context_menu.php';
        }

        public function becrosscp_load_textdomain() {
            load_plugin_textdomain( 'becrosscp', false, plugin_dir_path( __FILE__ ) . '/languages' );
        }

        public static function get_instance() {
            if (
                is_null( self::$_instance )
            ) {
                self::$_instance = new self();
            }
            return self::$_instance;
        }

    }
}

Be_Cross_Copy_Paste_Loader::get_instance();