<?php
/**
 * Quomodo Product Details Widget
 *
 */

if ( class_exists( 'Easy_Digital_Downloads' ) ) :

	class Aabbe_Market_Product_Details_Widget extends WP_Widget {

		/** Constructor */
		public function __construct() {
			parent::__construct(
				'themecore_edd_details_widget',
				sprintf( esc_html__( 'Aabbe %s Buy Buttons Details', 'themecore' ), edd_get_label_singular() ),
				array(
					'description' => sprintf( esc_html__( 'Display the details of a specific %s', 'themecore' ), edd_get_label_singular() ),
					)
				);
		}

		/** @see WP_Widget::widget */
		public function widget( $args, $instance ) {

			$args['id'] = ( isset( $args['id'] ) ) ? $args['id'] : 'edd_download_details_widget';
			if ( ! isset( $instance['download_id'] ) || ( 'current' == $instance['download_id'] && ! is_singular( 'download' ) ) ) {
				return;
			}
			/*set correct download ID*/
			if ( 'current' == $instance['download_id'] && is_singular( 'download' ) ) {
				$download_id = get_the_ID();
			} else {
				$download_id = absint( $instance['download_id'] );
			}

			global $post;
			global $edd_logs;
			$single_count      = $edd_logs->get_log_count(get_the_id(), 'file_download');
			$total_count       = $edd_logs->get_log_count('*', 'file_download');
			$price             = edd_get_download_price( $download_id );
			
			$sales             = edd_get_download_sales_stats( get_the_ID() );
			$sales             = $sales > 1 ? $sales . ' Sales' : $sales . ' Sale';
			
			$download_tags     = get_the_term_list( $download_id, 'download_tag',  ' ', ' ');
			$release_date      = get_the_date();
			$modified_date     = get_the_modified_date();
			$download_category = get_the_category( $download_id );
			//$tota_file_size    = aabbe_edd_show_total_file_size( get_the_id() );

			/*Variables from widget settings*/
			$title                = apply_filters( 'widget_title', $instance[ 'title' ] );
			$purchase_button      = $instance['purchase_button'] ? apply_filters( 'edd_product_details_widget_purchase_button', edd_get_purchase_link( array( 'download_id' => $download_id ) ), $download_id ) : '';
			$purchase_button_free = $instance['purchase_button_free'] ? apply_filters( 'edd_product_details_widget_purchase_button', edd_get_purchase_link( array( 'download_id' => $download_id ) ), $download_id ) : '';
			$free_download_text   = apply_filters( 'free_download_text', $instance[ 'free_download_text' ] );
			$show_buynow_button   = $instance[ 'show_buynow_button' ] ? 'true' : 'false';
			
			/*------------------------
				START CONTENT
			-------------------------*/
			echo $args['before_widget'];

	 		if ( ! empty( $title ) ) {
				echo $args['before_title'] . $title . $args['after_title'];
			}
		?>
			<div class="product__buy__widget single__product__widget">
				<div class="buy__top__price">
					<?php
					    if( $price == "0.00"  ){

							if(edd_has_variable_prices($download_id)){
								echo edd_price_range( $download_id );
							}else{

								if( $free_download_text ){
				    		 		echo esc_html($free_download_text);
				    		 	}else{
				    		 		edd_price($download_id);
				    		 	}
						    }
						}else{

							if(edd_has_variable_prices($download_id)){
								echo edd_price_range( $download_id );
							}else{
								edd_price($download_id);
							}
						}
					?>
				</div>
				<?php
					/* PRICE DESC */
					/*do_action( 'edd_download_price_table_head');
					edd_vpd_output_description( $key, $price, $download_id );*/
					if ( !empty( $instance['variable_price_desc'] )) {
						echo '<p class="price__desc">'.esc_html( $instance['variable_price_desc'] ).'</p>';
					}
				?>
				<div class="buy__bottom__details">
					<div class="buy__now__addcart__buttons">

			    		<?php
			    			if( $price == "0.00"  ){
				    			if( edd_has_variable_prices($download_id) ){
										do_action( 'edd_product_details_widget_before_title' , $instance , $download_id );
										do_action( 'edd_product_details_widget_before_purchase_button' , $instance , $download_id );
										echo ($purchase_button); 
								} else {
						    		do_action( 'edd_product_details_widget_before_title' , $instance , $download_id );
						            do_action( 'edd_product_details_widget_before_purchase_button' , $instance , $download_id );
						    		echo ($purchase_button_free);
					    		} 
				    		}else{
								do_action( 'edd_product_details_widget_before_title' , $instance , $download_id );
								do_action( 'edd_product_details_widget_before_purchase_button' , $instance , $download_id );
								echo ($purchase_button);
							}
						?>
						<?php if( 'on' == $instance['show_buynow_button'] ) : ?>
							<div class="download__now__button">
							    <a href="<?php the_permalink( $download_id ); ?>checkout?edd_action=add_to_cart&download_id=<?php echo esc_attr( $download_id ); ?>">Buy Now</a>
							</div>
						<?php endif; ?>

						<?php 
							$live_demo_url     = get_post_meta( get_the_ID(), '_preview_url',true); 
							$live_preview_text = get_theme_mod( 'live_preview_text','Live Preview' );
						?>
						<?php if ( 'on' == $instance['show_preview_button'] && !empty($live_demo_url) ) : ?>
							<div class="download__preview__link">
						  		<a href="<?php echo esc_url( $live_demo_url ); ?>" target="<?php echo esc_attr__( '_blank', 'themecore' ); ?>"><?php echo esc_html($live_preview_text); ?></a>
							</div>
						<?php endif; ?>

					</div>
					<?php if( 'on' == $instance['show_sales_comment'] || 'on' == $instance['show_ratting'] ) : ?>
					<div class="buy__bottom__meta">
						<?php if( 'on' == $instance['show_sales_comment'] ) : ?>
							<div class="product__sale__comments__count">
								<div class="product__sale__count">
									<span class="count__icon"><i class="fa fa-shopping-cart"></i></span>
									<span class="count__text"><?php echo esc_html( $sales ); ?></span>
								</div>
								<div class="product__comments__count">
									<span class="count__icon"><i class="fa fa-comments"></i></span>
									<span class="count__text"><?php echo get_comments_number_text(esc_html__('0 Comment','themecore'),esc_html__('1 Comment','themecore'),esc_html__('% Comments','themecore')); ?></span>
								</div>
							</div>
						<?php endif; ?>
						<?php if( 'on' == $instance['show_ratting'] ) : ?>
							<div class="porduct__review__count">
							   	<?php
								   	if ( class_exists( 'EDD_Reviews' ) && is_singular( 'download' ) ) {
								   		if ( function_exists('aabbe_edd_rating') ) {
								   			aabbe_edd_rating(true,' Rating');
								   		}
									}
								?>
							</div>
						<?php endif; ?>
					</div>
					<?php endif; ?>
				</div>
			</div>
			<?php
			echo $args['after_widget'];
		}
		
		/** @see WP_Widget::form */
		public function form( $instance ) {
			/*Set up some default widget settings.*/
			$defaults = array(
				'title'                => sprintf( esc_html__( '%s Details', 'themecore' ), edd_get_label_singular() ),
				'download_id'          => 'current',
				'download_title'       => 'on',
				'purchase_button'      => 'on',
				'purchase_button_free' => 'on',
				'buy_button'           => 'on',
				'free_download_text'   => 'Free',
				'show_buynow_button'   => 'on',
				'show_preview_button'  => 'off',
				'show_sales_comment'   => 'on',
				'show_ratting'         => 'on',
				'variable_price_desc'  => '',
			);
			$instance = wp_parse_args( (array) $instance, $defaults ); ?>

			<p>
				<label for="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>"><?php esc_html_e( 'Title:', 'themecore' ) ?></label>
				<input class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'title' ) ); ?>" type="text" value="<?php echo esc_attr($instance['title']); ?>" />
			</p>

			<?php
				$args = array(
					'post_type'      => 'download',
					'posts_per_page' => -1,
					'post_status'    => 'publish',
					);
				$downloads = get_posts( $args );
			?>
			<p>
				<label for="<?php echo esc_attr( $this->get_field_id( 'download_id' ) ); ?>"><?php printf( esc_html__( '%s', 'themecore' ), edd_get_label_singular() ); ?></label>
				<select class="widefat" name="<?php echo esc_attr( $this->get_field_name( 'download_id' ) ); ?>" id="<?php echo esc_attr( $this->get_field_id( 'download_id' ) ); ?>">
					<option value="current"><?php esc_html_e( 'Use current', 'themecore' ); ?></option>
					<?php foreach ( $downloads as $download ) { ?>
					<option <?php selected( absint( $instance['download_id'] ), $download->ID ); ?> value="<?php echo esc_attr( $download->ID ); ?>"><?php echo esc_html($download->post_title); ?></option>
					<?php } ?>
				</select>
			</p>

			<p>
				<input <?php checked( $instance['show_preview_button'], 'on' ); ?> id="<?php echo esc_attr( $this->get_field_id( 'show_preview_button' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'show_preview_button' ) ); ?>" type="checkbox" />
				<label for="<?php echo esc_attr( $this->get_field_id( 'show_preview_button' ) ); ?>"><?php esc_html_e( 'Show Preview Button', 'themecore' ); ?></label>
			</p>
			<p>
				<input <?php checked( $instance['purchase_button'], 'on' ); ?> id="<?php echo esc_attr( $this->get_field_id( 'purchase_button' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'purchase_button' ) ); ?>" type="checkbox" />
				<label for="<?php echo esc_attr( $this->get_field_id( 'purchase_button' ) ); ?>"><?php esc_html_e( 'Show Add to Cart Button', 'themecore' ); ?></label>
			</p>

			<p>
				<input <?php checked( $instance['purchase_button_free'], 'on' ); ?> id="<?php echo esc_attr( $this->get_field_id( 'purchase_button_free' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'purchase_button_free' ) ); ?>" type="checkbox" />
				<label for="<?php echo esc_attr( $this->get_field_id( 'purchase_button_free' ) ); ?>"><?php esc_html_e( 'Show Cart Button on Free Products', 'themecore' ); ?></label>
			</p>

			<p>
				<label for="<?php echo $this->get_field_id( 'free_download_text' ); ?>"><?php _e('Custom Text ( when the price is 0 ) othewise it will be show 0 price', 'themecore'); ?>
				<input class="widefat" type="text" value="<?php echo esc_attr($instance['free_download_text']); ?>"  id="<?php echo $this->get_field_id( 'free_download_text' ); ?>" name="<?php echo $this->get_field_name( 'free_download_text' ); ?>" /> 
				</label>
			</p>

			<p>
				<input <?php checked( $instance['show_buynow_button'], 'on' ); ?> id="<?php echo esc_attr( $this->get_field_id( 'show_buynow_button' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'show_buynow_button' ) ); ?>" type="checkbox" />
				<label for="<?php echo esc_attr( $this->get_field_id( 'show_buynow_button' ) ); ?>"><?php esc_html_e( 'Show Buy Now Button', 'themecore' ); ?></label>
			</p>

			<p>
				<input <?php checked( $instance['show_sales_comment'], 'on' ); ?> id="<?php echo esc_attr( $this->get_field_id( 'show_sales_comment' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'show_sales_comment' ) ); ?>" type="checkbox" />
				<label for="<?php echo esc_attr( $this->get_field_id( 'show_sales_comment' ) ); ?>"><?php esc_html_e( 'Show Sales and Comment Count', 'themecore' ); ?></label>
			</p>

			<p>
				<input <?php checked( $instance['show_ratting'], 'on' ); ?> id="<?php echo esc_attr( $this->get_field_id( 'show_ratting' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'show_ratting' ) ); ?>" type="checkbox" />
				<label for="<?php echo esc_attr( $this->get_field_id( 'show_ratting' ) ); ?>"><?php esc_html_e( 'Show Ratting Count', 'themecore' ); ?></label>
			</p>

			<p>
				<label for="<?php echo esc_attr( $this->get_field_id( 'variable_price_desc' ) ); ?>"><?php esc_html_e( 'Variable Price Desc', 'themecore' ) ?></label>
				<textarea class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'variable_price_desc' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'variable_price_desc' ) ); ?>" cols="30" rows="4"><?php echo esc_html($instance['variable_price_desc']); ?></textarea>

			</p>

			<?php 
			//do_action( 'edd_product_details_widget_form' , $instance );
		}

		/** @see WP_Widget::update */
		public function update( $new_instance, $old_instance ) {
			$instance                         = $old_instance;
			$instance['title']                = sanitize_text_field( $new_instance['title'] );
			$instance['download_id']          = strip_tags( $new_instance['download_id'] );
			$instance['show_preview_button']  = isset( $new_instance['show_preview_button'] ) ? $new_instance['show_preview_button'] : '';
			$instance['purchase_button']      = isset( $new_instance['purchase_button'] ) ? $new_instance['purchase_button'] : '';
			$instance['purchase_button_free'] = isset( $new_instance['purchase_button_free'] ) ? $new_instance['purchase_button_free'] : '';
			$instance['free_download_text']   = sanitize_text_field( $new_instance['free_download_text'] );
			$instance['show_buynow_button']   = isset( $new_instance['show_buynow_button'] ) ? $new_instance['show_buynow_button'] : '';
			$instance['show_sales_comment']   = isset( $new_instance['show_sales_comment'] ) ? $new_instance['show_sales_comment'] : '';
			$instance['show_ratting']         = isset( $new_instance['show_ratting'] ) ? $new_instance['show_ratting'] : '';
			$instance['variable_price_desc']  = sanitize_text_field( $new_instance['variable_price_desc'] );
			//do_action( 'edd_product_details_widget_update', $instance );
			return $instance;
		}
	}

	function themecore_edd_details_widget(){
		register_widget('Aabbe_Market_Product_Details_Widget');
	}
	add_action('widgets_init', 'themecore_edd_details_widget');

endif;
