<?php

/**
 * Registers a new post type
 * @uses $wp_post_types Inserts new post type object into the list
 *
 * @param  string          Post type key, must not exceed 20 characters
 * @param  array|string    See  optional args description above.
 * @return object|WP_Error the registered post type object, or an error object
 */
if ( !function_exists( 'themecore_portfolio' ) ) {
    function themecore_portfolio() {

        /*----------------------------------------
        REGISTER CPT PORTFOLIO
        -----------------------------------------*/
        $labels = array(
            'name'               => esc_html__( 'Portfolios', 'themecore' ),
            'singular_name'      => esc_html__( 'Portfolio', 'themecore' ),
            'add_new'            => _x( 'Add New Portfolio', 'themecore', 'themecore' ),
            'add_new_item'       => esc_html__( 'Add New Portfolio', 'themecore' ),
            'edit_item'          => esc_html__( 'Edit Portfolio', 'themecore' ),
            'new_item'           => esc_html__( 'New Portfolio', 'themecore' ),
            'view_item'          => esc_html__( 'View Portfolio', 'themecore' ),
            'search_items'       => esc_html__( 'Search Portfolios', 'themecore' ),
            'not_found'          => esc_html__( 'No Portfolios found', 'themecore' ),
            'not_found_in_trash' => esc_html__( 'No Portfolios found in Trash', 'themecore' ),
            'parent_item_colon'  => esc_html__( 'Parent Portfolio:', 'themecore' ),
            'menu_name'          => esc_html__( 'Portfolios', 'themecore' ),
        );
        $args = array(
            'labels'              => $labels,
            'hierarchical'        => false,
            'description'         => 'description',
            'public'              => true,
            'show_ui'             => true,
            'show_in_menu'        => true,
            'show_in_admin_bar'   => true,
            'menu_position'       => 11,
            'menu_icon'           => 'dashicons-portfolio',
            'show_in_nav_menus'   => true,
            'publicly_queryable'  => true,
            'exclude_from_search' => false,
            'has_archive'         => true,
            'query_var'           => true,
            'can_export'          => true,
            'rewrite'             => true,
            'capability_type'     => 'page',
            'supports'            => array(
                'title',
                'editor',
                'thumbnail',
                'revisions',
            ),
        );
        register_post_type( 'portfolio', $args );

        /*----------------------------------------
        TEXONOMY REGISTER FOR PORTFOLIO
        -----------------------------------------*/
        $labels = array(
            'name'                  => _x( 'Portfolio Categories', 'Taxonomy Categories', 'themecore' ),
            'singular_name'         => _x( 'Portfolio Category', 'Taxonomy Portfolio Category', 'themecore' ),
            'search_items'          => __( 'Search Categories', 'themecore' ),
            'popular_items'         => __( 'Popular Categories', 'themecore' ),
            'all_items'             => __( 'All Categories', 'themecore' ),
            'parent_item'           => __( 'Parent Portfolio Category', 'themecore' ),
            'parent_item_colon'     => __( 'Parent Portfolio Category', 'themecore' ),
            'edit_item'             => __( 'Edit Portfolio Category', 'themecore' ),
            'update_item'           => __( 'Update Portfolio Category', 'themecore' ),
            'add_new_item'          => __( 'Add New Portfolio Category', 'themecore' ),
            'new_item_name'         => __( 'New Portfolio Category', 'themecore' ),
            'add_or_remove_items'   => __( 'Add or remove categories', 'themecore' ),
            'choose_from_most_used' => __( 'Choose from most used categories', 'themecore' ),
            'menu_name'             => __( 'Portfolio Categories', 'themecore' ),
        );
        $args = array(
            'labels'            => $labels,
            'public'            => true,
            'show_in_nav_menus' => false,
            'show_admin_column' => false,
            'hierarchical'      => true,
            'show_tagcloud'     => true,
            'show_ui'           => true,
            'query_var'         => true,
            'rewrite'           => true,
            'query_var'         => true,
            'capabilities'      => array(),
        );
        register_taxonomy( 'portfolio_category', array( 'portfolio' ), $args );

        /*----------------------------------------
        TEXONOMY REGISTER FOR PORTFOLIO TAGS
        -----------------------------------------*/
        $labels = array(
            'name'                  => _x( 'Portfolio Tags', 'Taxonomy tags', 'themecore' ),
            'singular_name'         => _x( 'Tags', 'Taxonomy tags', 'themecore' ),
            'search_items'          => __( 'Search tags', 'themecore' ),
            'popular_items'         => __( 'Popular tags', 'themecore' ),
            'all_items'             => __( 'All tags', 'themecore' ),
            'parent_item'           => __( 'Parent tags', 'themecore' ),
            'parent_item_colon'     => __( 'Parent tags', 'themecore' ),
            'edit_item'             => __( 'Edit tags', 'themecore' ),
            'update_item'           => __( 'Update tags', 'themecore' ),
            'add_new_item'          => __( 'Add New tags', 'themecore' ),
            'new_item_name'         => __( 'New tags Name', 'themecore' ),
            'add_or_remove_items'   => __( 'Add or remove tags', 'themecore' ),
            'choose_from_most_used' => __( 'Choose from most used tags', 'themecore' ),
            'menu_name'             => __( 'Portfolio Tags', 'themecore' ),
        );
        $args = array(
            'labels'            => $labels,
            'public'            => true,
            'show_in_nav_menus' => false,
            'show_admin_column' => false,
            'hierarchical'      => false,
            'show_tagcloud'     => true,
            'show_ui'           => true,
            'query_var'         => true,
            'rewrite'           => true,
            'query_var'         => true,
            'capabilities'      => array(),
        );
        register_taxonomy( 'portfolio_tags', array( 'portfolio' ), $args );

    }
}
add_action( 'init', 'themecore_portfolio' );

register_deactivation_hook( __FILE__, 'flush_rewrite_rules' );
register_activation_hook( __FILE__, 'themecore_flush_rewrites' );
function themecore_flush_rewrites() {
    themecore_portfolio();
    flush_rewrite_rules();
}