<?php

/*------------------------------
    HEADER BACKGROUND
-------------------------------*/
if(!function_exists('utech_header_background_image_load' )){
    function utech_header_background_image_load(){

        if ( is_page() ) {
            /*----------------------------
                PAGE META DATA
            -----------------------------*/
            $page_meta_array = utech_metabox_value('_utech_page_metabox' );

            /*---------------------------
                PAGE HEADER META
            -----------------------------*/
            $enable_header_styling  = isset( $page_meta_array['enable_header_styling'] ) ? $page_meta_array['enable_header_styling'] : false;
            $menu_align              = isset( $page_meta_array['menu_align'] ) ? $page_meta_array['menu_align'] : UTECH_HEADER_ALIGN;
            $menu_color              = isset( $page_meta_array['menu_color'] ) ? $page_meta_array['menu_color'] : '#ffffff';
            $menu_hover              = isset( $page_meta_array['menu_hover'] ) ? $page_meta_array['menu_hover'] : '#0045ff';
            $menu_sticky_color       = isset( $page_meta_array['menu_sticky_color'] ) ? $page_meta_array['menu_sticky_color'] : '#00274e';
            $menu_sticky_hover_color = isset( $page_meta_array['menu_sticky_hover_color'] ) ? $page_meta_array['menu_sticky_hover_color'] : '#0045ff';

            /*---------------------------
                MENU DROPDOWN
            ----------------------------*/
            $menu_dropdown_color            = isset( $page_meta_array['menu_dropdown_color'] ) ? $page_meta_array['menu_dropdown_color'] : '#ffffff';
            $menu_dropdown_hover_color      = isset( $page_meta_array['menu_dropdown_hover_color'] ) ? $page_meta_array['menu_dropdown_hover_color'] : '#0045ff';
            $menu_dropdown_hover_background = isset( $page_meta_array['menu_dropdown_hover_background'] ) ? $page_meta_array['menu_dropdown_hover_background'] : 'transparent';
            $menu_border_color              = isset( $page_meta_array['menu_border_color'] ) ? $page_meta_array['menu_border_color'] : 'rgba(255,255,255,0.15)';

            /* ---------------------------
                MENU ITEM ANIMATED BORDER
            -----------------------------*/
            $enable_menu_item_animated_border          = isset( $page_meta_array['enable_menu_item_animated_border'] ) ? $page_meta_array['enable_menu_item_animated_border'] : false;
            $enable_dropdown_menu_item_animated_border = isset( $page_meta_array['enable_dropdown_menu_item_animated_border'] ) ? $page_meta_array['enable_dropdown_menu_item_animated_border'] : false;

            /*---------------------------
                PAGE BARNER META
            -----------------------------*/
            $enable_banner_overlay  = isset( $page_meta_array['enable_overlay'] ) ? $page_meta_array['enable_overlay'] : false;
            $banner_overlay_opacity = isset( $page_meta_array['banner_overlay_opacity'] ) ? $page_meta_array['banner_overlay_opacity'] : '0.70';

            /*---------------------------
                PAGE FOOTER META
            -----------------------------*/
            $enable_footer_styling = isset( $page_meta_array['enable_footer_styling'] ) ? $page_meta_array['enable_footer_styling'] : false;
            $footer_overlay_opacity = isset( $page_meta_array['footer_overlay_opacity'] ) ? $page_meta_array['footer_overlay_opacity'] : '01';

            /*---------------------------
                PAGE CUSTOM CSS META
            -----------------------------*/
            $page_cs_css = isset( $page_meta_array['page_cs_css'] ) ? $page_meta_array['page_cs_css'] : '';
        }

        $custom_css = "";

        /*--------------------------
            HEADER BACKGROUND
        ---------------------------*/
        $blog_banner = utech_get_option( 'blog_page_banner' );
        $blog_banner = wp_get_attachment_image_url( $blog_banner, 'full' );
        if( is_page() && has_post_thumbnail()){
            $header_background = get_the_post_thumbnail_url(null, 'large' );
        }elseif( !empty( $blog_banner ) ){
            $header_background = $blog_banner;
        }else{
            $header_background = get_header_image();
        }
        if ( $header_background ) {
            $custom_css .= "
                .banner-area-bg {
                    background-image: url($header_background);
                }
            ";
        }

        /*--------------------------
            HEADER TEXT COLOR
        ---------------------------*/
        $header_text_color = utech_get_option( 'header_textcolor', '#ffffff' );
        
        if( !empty( $header_text_color ) && isset( $header_text_color ) ){            
            $header_text_color = $header_text_color;
        }else{
            $header_text_color = get_header_textcolor();
            $header_text_color = '#'.$header_text_color;
        }
        $custom_css .="
            .banner-area{
                text-align:".utech_get_option( 'header_text_align', 'center' ).";
            }
            .page-title h1,
            .page-title,
            .breadcumb,
            .breadcumb a,
            .breadcumb a span{
                color:".$header_text_color.";
            }
        ";

        /*---------------------------
            TEXT LOGO COLOR
        -----------------------------*/
        $custom_css .="
            .navbar-header h3 a{
                color:".utech_get_option( 'logo_color', '#ffffff' ).";
            }
            .is-sticky .navbar-header h3 a{
                color:".utech_get_option( 'sticky_logo_color', '#202030' ).";
            }
        ";

        /*-----------------------------
            TEXT LOGO COLOR ON MOBILE
        ------------------------------*/
        $custom_css .="
            @media (max-width: 991px) and (min-width: 768px){
                .navbar-header h3 a {
                    color:".utech_get_option( 'mobile_logo_color', '#ffffff' ).";
                }
                .is-sticky .navbar-header h3 a {
                    color:".utech_get_option( 'mobile_sticky_logo_color', '#202030' ).";
                }
            }
            @media only screen and (max-width: 767px){
                .navbar-header h3 a {
                    color:".utech_get_option( 'mobile_logo_color', '#ffffff' ).";
                }
                .is-sticky .navbar-header h3 a {
                    color:".utech_get_option( 'mobile_sticky_logo_color', '#202030' ).";
                }
            }
        ";

        /*-------------------------------
            BARNER OVERLAY
        -------------------------------*/
        if ( is_page() && $enable_banner_overlay == true ) {
            $custom_css .="
                .banner-area-bg::after{
                    opacity:". utech_meta_data( $banner_overlay_opacity ) ." !important;
                }
            ";
        }else{
            $custom_css .="
                .banner-area-bg::after{
                    opacity:".utech_get_option( 'blog_page_overlay_opacity', '0.70' ).";
                }
            ";
        }

        /*-------------------------------
            MENU ALIGN
        --------------------------------*/
        if ( is_page() && $enable_header_styling == true ) {
            if ( $menu_align == 'left' ) {
                $custom_css .="
                    #main-nav{
                        margin-left:inherit;
                    }
                ";
            }
            if ( $menu_align == 'center' ) {
                $custom_css .="
                    #main-nav{
                        text-align:". utech_meta_data( $menu_align ) .";
                    }
                ";
            }
            if ( $menu_align == 'right' ) {
                $custom_css .="
                    #main-nav{
                        margin-right:inherit;
                    }
                ";
            }
        }else{
            if ( utech_get_option( 'menu_align', UTECH_HEADER_ALIGN ) == 'left' ) {
                $custom_css .="
                    #main-nav{
                        margin-left:inherit;
                    }
                ";
            }
            if ( utech_get_option( 'menu_align', UTECH_HEADER_ALIGN ) == 'center' ) {
                $custom_css .="
                    #main-nav{
                        text-align:".utech_get_option( 'menu_align' ).";
                    }
                ";
            }
            if ( utech_get_option( 'menu_align', UTECH_HEADER_ALIGN ) == 'right' ) {
                $custom_css .="
                    #main-nav{
                        margin-right:inherit;
                    }
                ";
            }
        }

        /*--------------------------------
            MENU BACKGROUND OPACITY
        ---------------------------------*/
        $custom_css .="
            .mainmenu-area-bg {
                opacity: .".utech_get_option( 'menu_bg_opacity', '0' ).";
            }
        ";

        /*-------------------------------
            STICKY MENU BACKGROUND OPACITY
        --------------------------------*/
        $custom_css .="
			.is-sticky .mainmenu-area-bg {
			 	opacity: .".utech_get_option( 'sticky_menu_bg_opacity', '1' ).";
			}
        ";

        /*-------------------------------
            MENU COLORS
        --------------------------------*/
        if ( is_page() && $enable_header_styling == true ) {
            // Menu Color        
            $custom_css .="
                ul#nav li a {
                    color: ". utech_meta_data( $menu_color ) .";
                }
            ";

            // Sticky Menu Color        
            $custom_css .="
                .is-sticky ul#nav li a,
                ul#nav li li a {
                    color: ". utech_meta_data( $menu_sticky_color ) .";
                }
            ";

            // Menu Hover Color
            $custom_css .="
                ul#nav li a:hover,
                ul#nav li > a.active,
                ul#nav li.current-menu-parent > a,
                ul#nav li.current-menu-item > a,
                ul#nav li.hover > a,
                ul#nav li:hover > a{
                    color: ". utech_meta_data( $menu_hover ) .";
                }
            ";

            // Sticky Menu Hover Color
            $custom_css .="
                .is-sticky ul#nav li > a:hover,
                .is-sticky ul#nav > li:hover > a,
                .is-sticky ul#nav li ul li > a:hover,
                .is-sticky ul#nav li > a.active,
                .is-sticky ul#nav li.hover > a,
                .is-sticky ul#nav li.current-menu-parent > a,
                .is-sticky ul#nav li.current-menu-item > a {
                    color: ". utech_meta_data( $menu_sticky_hover_color ) .";
                }
            ";

            // Dorpdown Color
            $custom_css.="
                ul#nav li li a,
                .is-sticky ul#nav li li a{
                    color: ". utech_meta_data( $menu_dropdown_color ) ." !important;
                }
            ";
            $custom_css.="
                ul#nav li ul li.hover > a,
                ul#nav li.has-sub li.current-menu-item > a,
                .is-sticky ul#nav li ul li.hover > a{
                    color: ". utech_meta_data( $menu_dropdown_hover_color ) ." !important;
                    background: ". utech_meta_data( $menu_dropdown_hover_background ) ." !important;
                }
            ";
        }else{
            // Menu Color        
            $custom_css .="
    			ul#nav li a {
    				color: ".utech_get_option( 'menu_color', '#ffffff' ).";
    			}
            ";

            // Sticky Menu Color        
            $custom_css .="
                .is-sticky ul#nav li a,
                ul#nav li li a {
                    color: ".utech_get_option( 'menu_sticky_color', '#00274e' ).";
                }
            ";

            // Menu Hover Color
            $custom_css .="
                ul#nav li a:hover,
                ul#nav li > a.active,
                ul#nav li.current-menu-parent > a,
                ul#nav li.current-menu-item > a,
                ul#nav li.hover > a,
                ul#nav li:hover > a{
                    color: ".utech_get_option( 'menu_hover', '#ffffff' ).";
                }
            ";

            // Sticky Menu Hover Color
            $custom_css .="
                .is-sticky ul#nav li > a:hover,
                .is-sticky ul#nav > li:hover > a,
                .is-sticky ul#nav li ul li > a:hover,
                .is-sticky ul#nav li > a.active,
                .is-sticky ul#nav li.hover > a,
                .is-sticky ul#nav li.current-menu-parent > a,
                .is-sticky ul#nav li.current-menu-item > a {
                    color: ".utech_get_option( 'menu_sticky_hover_color', '#0045ff' ).";
                }
            ";

            // Dropdown Colors
            $custom_css.="
                ul#nav li li a,
                .is-sticky ul#nav li li a{
                    color: ".utech_get_option( 'menu_dropdown_color', '#ffffff' )." !important;
                }
            ";
            $custom_css.="
                ul#nav li ul li.hover > a,
                ul#nav li.has-sub li.current-menu-item > a,
                .is-sticky ul#nav li ul li.hover > a{
                    color: ".utech_get_option( 'menu_dropdown_hover_color', '#0045ff' )." !important;
                    background: ".utech_get_option( 'menu_dropdown_hover_background', 'transparent' )." !important;
                }
            ";
        }
        
        /*-------------------------------
            MENU ITEM ANIMATED BORDER
        --------------------------------*/
        if( is_page() && '1' == utech_meta_data( $enable_menu_item_animated_border, '0' ) ){

            $custom_css .="
                @media only screen and (min-width: 992px) {            
                    ul#nav>li.menu-item .wee {
                        display: block;
                    }
                }
            ";
        }elseif( '1' == utech_get_option( 'enable_menu_item_animated_border', '0' ) ){

            $custom_css .="
                @media only screen and (min-width: 992px) {            
                    ul#nav>li.menu-item .wee {
                        display: block;
                    }
                }
            ";
        }

        /*-------------------------------
            MENU DROPDOWN ITEM ANIMATED BORDER
        --------------------------------*/
        if( is_page() && '1' == utech_meta_data( $enable_dropdown_menu_item_animated_border, '0' ) ){

            $custom_css .="
                @media only screen and (min-width: 992px) {
                    ul#nav li ul li {
                        margin-bottom: 20px;
                        padding-left: 10px;
                        display: block;
                    }
                
                    ul#nav li ul li:last-child {
                        margin-bottom: 0;
                    }
                    .stellarnav ul li.mega>ul>li ul li a,
                    ul#nav li ul li a,
                    .is-sticky ul#nav li ul li a {
                        position: relative;
                        padding: 0;
                        display: inline-block;
                    }
                
                    .stellarnav ul li.mega>ul>li ul li a:after,
                    ul#nav li ul li a:after {
                        content: '';
                        width: 0%;
                        height: 1px;
                        background: #0045ff;
                        position: absolute;
                        right: 0;
                        bottom: 0;
                        transition: 0.5s;
                        transform: rotate(0) !important;
                    }
                    
                    .stellarnav ul li.mega>ul>li ul li a:hover:after,
                    ul#nav li ul li a:hover:after,
                    ul#nav li ul li:hover > a:after {
                        width: 100%;
                        left: 0;
                        right: auto;
                    }
                }
            ";
        }elseif( '1' == utech_get_option( 'enable_dropdown_menu_item_animated_border', '0' ) ){

            $custom_css .="
                @media only screen and (min-width: 992px) {
                    ul#nav li ul li {
                        margin-bottom: 20px;
                        padding-left: 10px;
                        display: block;
                    }
                
                    ul#nav li ul li:last-child {
                        margin-bottom: 0;
                    }
                
                    .stellarnav ul li.mega>ul>li ul li a,
                    ul#nav li ul li a,
                    .is-sticky ul#nav li ul li a {
                        position: relative;
                        padding: 0;
                        display: inline-block;
                    }
                    .stellarnav ul li.mega>ul>li ul li a:after,
                    ul#nav li ul li a:after {
                        content: '';
                        width: 0%;
                        height: 1px;
                        background: #0045ff;
                        position: absolute;
                        right: 0;
                        bottom: 0;
                        transition: 0.5s;
                        transform: rotate(0) !important;
                    }
                    .stellarnav ul li.mega>ul>li ul li a:hover:after,
                    ul#nav li ul li a:hover:after,
                    ul#nav li ul li:hover > a:after {
                        width: 100%;
                        left: 0;
                        right: auto;
                        transform: rotate(0);
                    }
                }
            ";
        }
        
        /*-------------------------------
            MENU BOTTOM AREA BORDER COLOR
        --------------------------------*/
        $custom_css .="
            .mainmenu-area{
                border-color:".utech_get_option( 'menu_border_color', 'rgba(255, 255, 255, 0.15)' ).";
            }
        ";

        /*-------------------------------
            MOBILE MOBILE MENU STYLE
        --------------------------------*/

        if( 'offcanvas' == utech_get_option( 'mobile_menu_style', 'offcanvas' ) ){

            $custom_css .="
                @media only screen and (max-width: 992px) {
                    #main-nav {
                        display: none;
                    }
                }
            ";
        }
        
        $custom_css .="
            @media only screen and (max-width: 991px) {
                .mainmenu-area{
                    border-color:".utech_get_option( 'mobile_menu_border_color','rgba(255, 255, 255, 0.15)' ).";
                }
                .mainmenu-area-bg {
                    opacity: .".utech_get_option( 'mobile_menu_bg_opacity', '1' ).";
                }
                .is-sticky .mainmenu-area-bg {
                    opacity: .".utech_get_option( 'mobile_menu_sticky_bg_opacity', '1' ).";
                }

                .menu-toggle.full {
                    color: ".utech_get_option( 'mobile_menu_hamburger_color', '#ffffff' )." !important;
                    border-color:".utech_get_option( 'mobile_menu_hamburger_color', '#ffffff' ).";
                }
                .line {
                    stroke: ".utech_get_option( 'mobile_menu_hamburger_color', '#ffffff' ).";
                }

                .is-sticky .menu-toggle.full {
                    color: ".utech_get_option( 'mobile_sticky_menu_hamburger_color', '#202030' ).";
                    border-color: ".utech_get_option( 'mobile_sticky_menu_hamburger_color', '#202030' ).";
                }
                .is-sticky .line {
                    stroke: ".utech_get_option( 'mobile_sticky_menu_hamburger_color', '#202030' ).";
                }
                ul#nav li a,
                ul#nav li li a,
                .is-sticky ul#nav li a,
                .is-sticky ul#nav li li a {
                    color: ".utech_get_option( 'mobile_menu_color', '#00274e' )." !important;
                }

                ul#nav li.has-sub.open > a,
                ul#nav > li > a:hover,
                ul#nav li > a.active,
                ul#nav li.current-menu-item > a,
                ul#nav li.has-sub li.current-menu-item > a,
                ul#nav li.open.menu-item-has-children > a {
                    background: ".utech_get_option( 'mobile_menu_hover_background', '#ffffff' )." !important;
                    color: ".utech_get_option( 'mobile_menu_hover', '#0045ff' )." !important;
                }
            }
        ";

        /*-------------------------------
            FOOTER BACKGROUND & OVERLAY
        --------------------------------*/        
        if ( is_page() && !empty( $footer_overlay_opacity ) && $enable_footer_styling == true ) {
            $custom_css.="
                .footer-area-bg:after{
                    opacity:".utech_meta_data( $footer_overlay_opacity )." !important;
                }
            ";
        }else{
            $custom_css.="
                .footer-area-bg:after{
                    opacity:".utech_get_option( 'footer_overlay_opacity', 0.5 ).";
                }
            ";
        }

        /*---------------------------------
            SINGLE BLOG POST DROPCAPS
        ----------------------------------*/
        if ( '1' == utech_get_option( 'show_dropcaps', false ) ) {

            $custom_css.="
                .single .format-standard .post-content > p:first-of-type {
                    overflow: hidden;
                }

                .single .format-standard .post-content > p:first-of-type::first-letter {
                    color: #0045ff;
                    float: left;
                    font-size: 90px;
                    font-weight: 600;
                    margin-right: 10px;
                    line-height: 1;
                    overflow: hidden;
                    clear: both;
                }
            ";
        }

        /*----------------------------------
            CSS ALL DEVICE
        -----------------------------------*/
        if( utech_get_option( 'custom_css' ) ){
            $custom_css .= utech_get_option( 'custom_css' );
        }

        /*----------------------------------
            CSS IPAD DEVICE
        -----------------------------------*/
        if( utech_get_option( 'custom_css_ipad' ) ){
            $custom_css.="
                @media (min-width: 1024px) and (max-width: 1400px) {
                    ".utech_get_option( 'custom_css_ipad' )."
                }
            ";
        }

        /*----------------------------------
            CSS TABLET DEVICE
        -----------------------------------*/
        if( utech_get_option( 'custom_css_tablet' ) ){
            $custom_css.="
                @media (min-width: 768px) and (max-width: 991px) {
                    ".utech_get_option( 'custom_css_tablet' )."
                }
            ";
        }

        /*----------------------------------
            CSS MOBILE DEVICE
        -----------------------------------*/
        if( utech_get_option( 'custom_css_mobile' ) ){
            $custom_css.="
                @media only screen and (max-width: 767px) {
                    ".utech_get_option( 'custom_css_mobile' )."
                }
            ";
        }

        /*----------------------------------
            PAGE CUSTOM CSS
        -----------------------------------*/
        if ( is_page() ) {
            $custom_css .= utech_meta_data( $page_cs_css );
        }

        /*----------------------------------
            CSS OUTPUT STYLE
        -----------------------------------*/
        wp_add_inline_style( 'utech-main-style', $custom_css );
    }
}
add_action( 'wp_enqueue_scripts', 'utech_header_background_image_load' );