<?php

/*-----------------------------------
    LOGO SECTION
------------------------------------*/
CSF::createSection( UTECH_OPTION_KEY,
    array(
        'parent' => 'Header_Tab',
        'title'  => esc_html__( 'Offcanvas Panel', 'utech' ),
        'icon'   => 'fa fa-align-right',
        'fields' => array(
            array(
                'type'    => 'subheading',
                'content' => esc_html__( 'Offcanvas Logo', 'utech' ),
            ),
            array(
                'id'      => 'enable_offcanvas_logo',
                'type'    => 'switcher',
                'title'   => esc_html__( 'Enable OffCanvas Logo', 'utech' ),
                'desc'    => esc_html__( 'If you want to enable or disable offcanvas logo you can set ( YES / NO )', 'utech' ),
                'default' => true,
            ),
            array(
                'id'         => 'offcanvas_logo',
                'type'       => 'media',
                'title'      => esc_html__( 'Offcanvas Logo', 'utech' ),
                'desc'       => esc_html__( 'Upload offcanvas logo width 180px and height 80px.', 'utech' ),
                'default'    => '',
                'library'    => 'image',
                'preview'    => true,
                'url'        => false,
                'help'       => esc_html__( 'Note: Please use logo image max width: 250px and max height 100px.', 'utech' ),
                'dependency' => array( 'enable_offcanvas_logo', '==', 'true' ),
            ),
            array(
                'type'    => 'subheading',
                'content' => esc_html__( 'Offcanvas Search', 'utech' ),
            ),
            array(
                'id'      => 'enable_offcanvas_search',
                'type'    => 'switcher',
                'title'   => esc_html__( 'Enable OffCanvas Search', 'utech' ),
                'desc'    => esc_html__( 'If you want to enable or disable offcanvas search you can set ( YES / NO )', 'utech' ),
                'default' => true,
            ),
            array(
                'type'    => 'subheading',
                'content' => esc_html__( 'Offcanvas Description', 'utech' ),
            ),
            array(
                'id'      => 'enable_offcanvas_description',
                'type'    => 'switcher',
                'title'   => esc_html__( 'Enable OffCanvas Description', 'utech' ),
                'desc'    => esc_html__( 'If you want to enable or disable offcanvas description you can set ( YES / NO )', 'utech' ),
                'default' => true,
            ),
            array(
                'id'      => 'offcanvas_description',
                'type'    => 'textarea',
                'title'   => esc_html__( 'OffCanvas Description', 'utech' ),
                'desc'    => esc_html__( 'Set the offcanvas description text form here.', 'utech' ),
                'dependency' => array( 'enable_offcanvas_description', '==', 'true' ),
            ),
            array(
                'type'    => 'subheading',
                'content' => esc_html__( 'Offcanvas Mobile Menu Color', 'utech' ),
            ),
            array(
                'id'      => 'offcanvas_mobile_menu_color',
                'type'    => 'color',
                'title'   => esc_html__( 'Offcanvas Menu Color', 'utech' ),
                'desc'    => esc_html__( 'Set the menu color by color picker', 'utech' ),
                'default' => '#ffffff',
                'output'  => array('.offcanvas__navigation>ul>li>a','.offcanvas__navigation ul.sub-menu>li>a'),
                'output_important' => true,
            ),
            array(
                'id'      => 'offcanvas_mobile_menu_hover',
                'type'    => 'color',
                'title'   => esc_html__( 'Offcanvas Menu Active & Hover Color', 'utech' ),
                'desc'    => esc_html__( 'Set the menu item active &hover color by color picker', 'utech' ),
                'default' => '#0045ff',
                'output'  => array('.offcanvas__navigation>ul>li>a:hover','.offcanvas__navigation ul.sub-menu>li>a:hover'),
                'output_important' => true,
            ),
        ),
    )
);