<?php

/*-----------------------------------
EASY DIGITAL DOWNLOAD SECTION
------------------------------------*/
if ( !class_exists( 'Easy_Digital_Downloads' ) ) {
    return;
}

CSF::createSection( UTECH_OPTION_KEY,
    array(
        'parent' => 'Features_Tab',
        'title'  => esc_html__( 'Easy Digital Downloads', 'utech' ),
        'icon'   => 'fa fa-download',
        'fields' => array(

            array(
                'type'    => 'subheading',
                'content' => esc_html__( 'Product Setting', 'utech' ),
            ),
            array(
                'id'      => 'product_grid_style',
                'type'    => 'select',
                'title'   => esc_html__( 'Product Grid Style', 'utech' ),
                'desc'    => esc_html__( 'Set the product grid style which you want.', 'utech' ),
                'options' => array(
                    'product_grid_1' => esc_html__( 'Product Grid Style 1', 'utech' ),
                    'product_grid_2' => esc_html__( 'Product Grid Style 2', 'utech' ),
                ),
                'default' => 'product_grid_1',
            ),
            array(
                'id'      => 'enable_product_buynow_title',
                'type'    => 'switcher',
                'title'   => esc_html__( 'Custom Buynow Title?', 'utech' ),
                'desc'    => esc_html__( 'If you want to set custom buy now title you can set ( YES / NO )', 'utech' ),
                'default' => false,
            ),
            array(
                'id'         => 'product_buynow_title',
                'type'       => 'text',
                'title'      => esc_html__( 'Buynow Button Title', 'utech' ),
                'desc'       => esc_html__( 'Set your preferred custom buynow button title.', 'utech' ),
                'default'    => esc_html__( 'Purchase', 'utech' ),
                'dependency' => array( 'enable_product_buynow_title', '==', 'true' ),
            ),
            array(
                'id'      => 'enable_product_preview_text',
                'type'    => 'switcher',
                'title'   => esc_html__( 'Custom Preview Title?', 'utech' ),
                'desc'    => esc_html__( 'If you want to set custom preview title you can set ( YES / NO )', 'utech' ),
                'default' => false,
            ),
            array(
                'id'         => 'product_preview_text',
                'type'       => 'text',
                'title'      => esc_html__( 'Preview Button Title', 'utech' ),
                'desc'       => esc_html__( 'Set your preferred custom preview button title.', 'utech' ),
                'default'    => esc_html__( 'Preview', 'utech' ),
                'dependency' => array( 'enable_product_preview_text', '==', 'true' ),
            ),
            array(
                'id'      => 'product_variable_pricing_options',
                'type'    => 'select',
                'title'   => esc_html__( 'Product Variable Price Option', 'utech' ),
                'desc'    => esc_html__( 'Set the product variable price option which you want.', 'utech' ),
                'options' => array(
                    'default' => esc_html__( 'Default Style', 'utech' ),
                    'custom'  => esc_html__( 'Custom Style', 'utech' ),
                ),
                'default' => 'custom',
            ),
            array(
                'type'    => 'subheading',
                'content' => esc_html__( 'Product Archive Setting', 'utech' ),
            ),
            array(
                'id'      => 'edd_product_per_page',
                'type'    => 'slider',
                'title'   => esc_html__( 'Archive Product Per Page', 'utech' ),
                'desc'    => esc_html__( 'Set the product per page in all archive pages for edd product.', 'utech' ),
                'min'     => 1,
                'max'     => 100,
                'step'    => 1,
                'unit'    => '',
                'default' => 6,
            ),
            array(
                'type'    => 'subheading',
                'content' => esc_html__( 'Login Page Setting', 'utech' ),
            ),
            array(
                'id'      => 'login_page_logo',
                'type'    => 'media',
                'title'   => esc_html__( 'Upload Login Page Logo', 'utech' ),
                'desc'    => esc_html__( 'Upload a login page logo max width ( 250px ).', 'utech' ),
                'default' => '',
                'library' => 'image',
                'preview' => true,
                'url'     => false,
            ),
            array(
                'type'    => 'subheading',
                'content' => esc_html__( 'Email Template Setting', 'utech' ),
            ),
            array(
                'id'      => 'accent_color',
                'type'    => 'color',
                'title'   => esc_html__( 'Accent Color', 'utech' ),
                'desc'    => esc_html__( 'Set the email template accent color.', 'utech' ),
                'default' => '#ff3366',
            ),
            array(
                'id'      => 'accent_color_text',
                'type'    => 'color',
                'title'   => esc_html__( 'Accent Text Color', 'utech' ),
                'desc'    => esc_html__( 'Set the email template accent text color.', 'utech' ),
                'default' => '#ffffff',
            ),
            array(
                'id'      => 'regular_text_color',
                'type'    => 'color',
                'title'   => esc_html__( 'Text Color', 'utech' ),
                'desc'    => esc_html__( 'Set the email template text color.', 'utech' ),
                'default' => '#777777',
            ),
        ),
    )
);