<?php
use Elementor\Plugin;
use Elementor\Controls_Stack;
use Elementor\Utils;

defined( 'ABSPATH' ) || die();

class Be_Cross_Context_Menu {

    /**
     * Ajax action
     */
    const ACTION = 'be_process_ixport';

    /**
     * Initialize actions
     */
    public static function init() {

        if ( becrosscp_is_elementor_version( '>=', '2.8.0' ) ) {
            add_action( 'elementor/editor/after_enqueue_scripts', [__CLASS__, 'enqueue'] );
        } else {
            add_action( 'elementor/preview/enqueue_scripts', [__CLASS__, 'enqueue'] );
        }

        add_action( 'elementor/preview/enqueue_scripts', [__CLASS__, 'enqueue_preview'] );

        add_action( 'wp_ajax_' . self::ACTION, [__CLASS__, 'process_ixport'] );
    }

    /**
     * Process image import request
     *
     * @return void
     */
    public static function process_ixport() {
        $nonce   = isset( $_POST['nonce'] ) ? $_POST['nonce'] : '';
        $type    = isset( $_POST['type'] ) ? $_POST['type'] : 'import';
        $content = isset( $_POST['content'] ) ? wp_unslash( $_POST['content'] ) : '';

        if ( !wp_verify_nonce( $nonce, self::ACTION ) || !current_user_can( 'edit_posts' ) ) {
            wp_send_json_error( __( 'You are not allowed to complete this task, thank you.', 'beaddon' ), 403 );
        }

        if ( empty( $content ) ) {
            wp_send_json_error( __( 'Sorry, cannot process empty content!', 'beaddon' ) );
        }

        if ( $type === 'export' ) {
            $content = self::process_export_content( $content );
        } else {
            $content = self::process_import_content( $content );
        }

        wp_send_json_success( $content );
    }

    protected static function process_export_content( $content = '' ) {
        // Need to be an array to process through elementor db iterator
        $content = [json_decode( $content, true )];

        $xporter = new Be_Cross_IXPorter();
        $content = $xporter->replace_elements_ids( $content );
        $content = $xporter->process_export_import_content( $content, 'on_export' );

        return $content;
    }

    protected static function process_import_content( $content = '' ) {

        // Enable svg support
        add_filter( 'upload_mimes', [__CLASS__, 'add_svg_support'] );

        // Need to be an array to process through elementor db iterator
        $content = [json_decode( $content, true )];

        $xporter = new Be_Cross_IXPorter();
        $content = $xporter->replace_elements_ids( $content );
        $content = $xporter->process_export_import_content( $content, 'on_import' );

        // Disable svg support
        remove_filter( 'upload_mimes', [__CLASS__, 'add_svg_support'] );

        return $content;
    }

    public static function add_svg_support( $mimes ) {
        $mimes['svg'] = 'image/svg+xml';
        return $mimes;
    }

    public static function enqueue_preview() {
        $_file = plugin_dir_url( __FILE__ ) . 'assets/admin/css/preview.css';

        if ( is_readable( $_file ) ) {
            $content = file_get_contents( $_file );
            wp_add_inline_style( 'be-widgets', $content );
        }
    }

    /**
     * Enqueue assets.
     *
     * @return void
     */
    public static function enqueue() {
        if ( apply_filters( 'be_theme_context_active', false ) ) {
            
            wp_enqueue_script( 'beaddonlost-ls', plugin_dir_url( __FILE__ ) . 'assets/admin/js/beaddonlost-ls.min.js', null, '1.0.0', true );

            if ( becrosscp_is_elementor_version( '>=', '2.8.0' ) ) {
                $src          = plugin_dir_url( __FILE__ ) . 'assets/admin/js/beaddonlost-new.min.js';
                $dependencies = ['beaddonlost-ls', 'elementor-editor'];
            } else {
                $src          = plugin_dir_url( __FILE__ ) . 'assets/admin/js/beaddonlost.min.js';
                $dependencies = ['beaddonlost-ls'];
            }

            if( '0' == apply_filters( 'be_core_context_active', false ) ){  return; }

            wp_enqueue_script( 'beaddonlost', $src, $dependencies, '1.0.0', true );
            
            if( '0' == apply_filters( 'be_ul_context_active', false ) ){  return; }

            wp_localize_script(
                'beaddonlost',
                'beaddonlost',
                [
                    'storageKey' => md5( 'LICENSE KEY' ),
                    'ajaxURL'    => admin_url( 'admin-ajax.php' ),
                    'nonce'      => wp_create_nonce( self::ACTION ),
                ]
            );
        }
    }
}
Be_Cross_Context_Menu::init();