<?php

/*-----------------------------------
MAINMENU SECTION
------------------------------------*/
CSF::createSection( UTECH_OPTION_KEY,
    array(
        'parent' => 'Header_Tab',
        'title'  => esc_html__( 'Main Menu', 'utech' ),
        'icon'   => 'fa fa-sitemap',
        'fields' => array(

            array(
                'type'    => 'subheading',
                'content' => esc_html__( 'One Page Navigation Setting', 'utech' ),
            ),
            array(
                'id'      => 'one_page_navigation',
                'type'    => 'switcher',
                'title'   => esc_html__( 'One Page Navigation On ?', 'utech' ),
                'desc'    => esc_html__( 'If you want to enable or disable one page menu link effect it will be effect inside the page (#) links.', 'utech' ),
                'default' => false,
            ),
            array(
                'type'    => 'subheading',
                'content' => esc_html__( 'Menu Sticky', 'utech' ),
            ),
            array(
                'id'      => 'sticky_menu',
                'type'    => 'switcher',
                'title'   => esc_html__( 'Sticky Menu ?', 'utech' ),
                'desc'    => esc_html__( 'If you want to enable or disable menu sticky in header section you can set ( YES / NO )', 'utech' ),
                'default' => true,
            ),
            array(
                'type'    => 'subheading',
                'content' => esc_html__( 'Enable Header Action Buttons', 'utech' ),
            ),
            array(
                'id'      => 'enable_header_actions',
                'type'    => 'switcher',
                'title'   => esc_html__( 'Enable Header Action Buttons', 'utech' ),
                'desc'    => esc_html__( 'If you want to enable or disable header area action buttons you can set ( YES / NO )', 'utech' ),
                'default' => false,
            ),
            array(
                'type'       => 'subheading',
                'content'    => esc_html__( 'Menu Action Buttons', 'utech' ),
                'dependency' => array( 'enable_header_actions', '==', 'true' ),
            ),
            array(
                'id'         => 'enable_search',
                'type'       => 'switcher',
                'title'      => esc_html__( 'Enable Search Button', 'utech' ),
                'desc'       => esc_html__( 'If you want to enable or disable search button in menu section you can set ( YES / NO )', 'utech' ),
                'default'    => false,
                'dependency' => array( 'enable_header_actions', '==', 'true' ),
            ),
            array(
                'id'         => 'enable_offcanvas',
                'type'       => 'switcher',
                'title'      => esc_html__( 'Enable OffCanvas Sidebar Button', 'utech' ),
                'desc'       => esc_html__( 'If you want to enable or disable offcanvas button in menu section you can set ( YES / NO )', 'utech' ),
                'default'    => false,
                'dependency' => array( 'enable_header_actions', '==', 'true' ),
            ),

            array(
                'type'    => 'subheading',
                'content' => esc_html__( 'Enable Elementor Offcanvas', 'utech' ),
            ),
            array(
                'id'      => 'enable_offcanvas_content',
                'type'    => 'switcher',
                'title'   => esc_html__( 'Add Elementor Template', 'utech' ),
                'desc'    => esc_html__( 'If you want to set Elementor template as offcanvas template you can set ( YES / NO )', 'utech' ),
                'default' => false,
                'dependency' => array( 'enable_header_actions', '==', 'true' ),
            ),
            array(
                'id'      => 'elementor_offcanvas_content',
                'type'    => 'select',
                'title'   => esc_html__( 'Select Offcanvas Template Style', 'utech' ),
                'desc'    => esc_html__( 'You can chose and select offcanvas template type here, it will be effect in offcanvas panel content template..', 'utech' ),
                'options' => utech_get_elementor_post_array(),
                'dependency' => array( 'enable_header_actions|enable_offcanvas_content', '==|==', 'true|true' ),
            ),

            array(
                'id'         => 'enable_cart_button',
                'type'       => 'switcher',
                'title'      => esc_html__( 'Enable Cart Button', 'utech' ),
                'desc'       => esc_html__( 'If you want to enable or disable cart button in menu section you can set ( YES / NO )', 'utech' ),
                'default'    => false,
                'dependency' => array( 'enable_header_actions', '==', 'true' ),
            ),
            array(
                'id'         => 'enable_mini_cart',
                'type'       => 'switcher',
                'title'      => esc_html__( 'Enable Header Mini Cart', 'utech' ),
                'desc'       => esc_html__( 'If you want to enable or disable mini cart in header section you can set ( YES / NO )', 'utech' ),
                'default'    => false,
                'dependency' => array( 'enable_header_actions|enable_cart_button', '==|==', 'true|true' ),
            ),
            array(
                'id'         => 'enable_promo_menu',
                'type'       => 'switcher',
                'title'      => esc_html__( 'Enable Promo Menu Button', 'utech' ),
                'desc'       => esc_html__( 'If you want to enable or disable pro menu button in menu section you can set ( YES / NO )', 'utech' ),
                'default'    => false,
                'dependency' => array( 'enable_header_actions', '==', 'true' ),
            ),
            array(
                'id'         => 'enable_user_menu',
                'type'       => 'switcher',
                'title'      => esc_html__( 'Enable User Menu Button', 'utech' ),
                'desc'       => esc_html__( 'If you want to enable or disable user menu button in menu section you can set ( YES / NO )', 'utech' ),
                'default'    => false,
                'dependency' => array( 'enable_header_actions', '==', 'true' ),
            ),
            array(
                'id'         => 'enable_language_button',
                'type'       => 'switcher',
                'title'      => esc_html__( 'Enable Language Button', 'utech' ),
                'desc'       => esc_html__( 'If you want to enable or disable Language button in menu section you can set ( YES / NO )', 'utech' ),
                'default'    => false,
                'dependency' => array( 'enable_header_actions', '==', 'true' ),
            ),
            array(
                'id'         => 'enable_action',
                'type'       => 'switcher',
                'title'      => esc_html__( 'Enable Action Button', 'utech' ),
                'desc'       => esc_html__( 'If you want to enable or disable action button in menu section you can set ( YES / NO )', 'utech' ),
                'default'    => false,
                'dependency' => array( 'enable_header_actions', '==', 'true' ),
            ),
            array(
                'id'         => 'button_text',
                'type'       => 'text',
                'title'      => esc_html__( 'Button Text', 'utech' ),
                'desc'       => esc_html__( 'Set the button text here', 'utech' ),
                'dependency' => array( 'enable_action', '==', 'true' ),
                'default'    => 'Sign Up',
            ),
            array(
                'id'         => 'button_url',
                'type'       => 'text',
                'title'      => esc_html__( 'Button Link', 'utech' ),
                'desc'       => esc_html__( 'Set the button link here', 'utech' ),
                'dependency' => array( 'enable_action', '==', 'true' ),
                'default'    => '#',
            ),
            array(
                'id'         => 'button_text_2',
                'type'       => 'text',
                'title'      => esc_html__( 'Button Text 2', 'utech' ),
                'desc'       => esc_html__( 'Set the button text here', 'utech' ),
                'dependency' => array( 'enable_action', '==', 'true' ),
                'default'    => 'Login',
            ),
            array(
                'id'         => 'button_url_2',
                'type'       => 'text',
                'title'      => esc_html__( 'Button Link 2', 'utech' ),
                'desc'       => esc_html__( 'Set the button link here', 'utech' ),
                'dependency' => array( 'enable_action', '==', 'true' ),
                'default'    => '#',
            ),
            array(
                'type'    => 'subheading',
                'content' => esc_html__( 'Menu Width & Align', 'utech' ),
            ),
            array(
                'id'      => 'menu_width',
                'type'    => 'select',
                'title'   => esc_html__( 'Menu Container Width', 'utech' ),
                'desc'    => esc_html__( 'Set the menu with form here you can set ( FULLWIDTH / CONTAINER )', 'utech' ),
                'options' => array(
                    'container'                 => esc_html__( 'Container', 'utech' ),
                    'container container__full' => esc_html__( 'Container Full Width', 'utech' ),
                    'container-fluid'           => esc_html__( 'Full Width', 'utech' ),
                ),
                'default' => 'container',
            ),
            array(
                'id'      => 'menu_align',
                'type'    => 'select',
                'title'   => esc_html__( 'Menu Text Align', 'utech' ),
                'desc'    => esc_html__( 'Set the menu text align from here', 'utech' ),
                'options' => array(
                    'left'   => 'Left',
                    'center' => 'Center',
                    'right'  => 'Right',
                ),
                'default' => UTECH_HEADER_ALIGN,
            ),
            array(
                'type'    => 'subheading',
                'content' => esc_html__( 'Menu Area Background', 'utech' ),
            ),
            array(
                'id'                    => 'menu_bg',
                'type'                  => 'background',
                'title'                 => esc_html__( 'Menu Background', 'utech' ),
                'subtitle'              => esc_html__( 'Set the menu background.', 'utech' ),
                'desc'                  => esc_html__( 'Set the menu background color, image and gradient color. If you set only first color field it will be a simple solid color for background and if set 2nd color field too it will be set a gradient color and if you set a image it will be set a background image.', 'utech' ),
                'background_image'      => true,
                'background_position'   => true,
                'background_repeat'     => true,
                'background_attachment' => true,
                'background_size'       => true,
                'background_gradient'   => true,
                'background_origin'     => true,
                'background_clip'       => true,
                'background_blend_mode' => true,
                'output'                => '.mainmenu-area-bg',
            ),
            array(
                'id'          => 'menu_bg_opacity',
                'type'        => 'slider',
                'title'       => esc_html__( 'Background Opacity', 'utech' ),
                'desc'        => esc_html__( 'Set the menu background opacity here use max value 99 and minimum value 1 in decimal.', 'utech' ),
                'min'         => 0,
                'max'         => 1,
                'step'        => 0.01,
                'unit'        => ' ',
                'default'     => 0,
                'output_mode' => 'opacity',
                'output'      => '.mainmenu-area-bg',
            ),
            array(
                'id'                    => 'sticky_menu_bg',
                'type'                  => 'background',
                'title'                 => esc_html__( 'Menu Sticky Background', 'utech' ),
                'subtitle'              => esc_html__( 'Set the menu sticky background.', 'utech' ),
                'desc'                  => esc_html__( 'Set the menu sticky background color, image and gradient color. If you set only first color field it will be a simple solid color for background and if set 2nd color field too it will be set a gradient color and if you set a image it will be set a background image.', 'utech' ),
                'background_image'      => true,
                'background_position'   => true,
                'background_repeat'     => true,
                'background_attachment' => true,
                'background_size'       => true,
                'background_gradient'   => true,
                'background_origin'     => true,
                'background_clip'       => true,
                'background_blend_mode' => true,
                'output'                => '.is-sticky .mainmenu-area-bg,.sticky-active .mainmenu-area-bg',
            ),
            array(
                'id'          => 'sticky_menu_bg_opacity',
                'type'        => 'slider',
                'title'       => esc_html__( 'Sticky Background Opacity', 'utech' ),
                'desc'        => esc_html__( 'Set the menu sticky background opacity here use max value 99 and minimum value 1 in decimal.', 'utech' ),
                'min'         => 0,
                'max'         => 1,
                'step'        => 0.01,
                'unit'        => ' ',
                'default'     => 1,
                'output_mode' => 'opacity',
                'output'      => '.is-sticky .mainmenu-area-bg,.sticky-active .mainmenu-area-bg',
            ),
            array(
                'type'    => 'subheading',
                'content' => esc_html__( 'Menu Typography', 'utech' ),
            ),
            array(
                'id'                 => 'menu_font',
                'type'               => 'typography',
                'title'              => esc_html__( 'Menu Typography', 'utech' ),
                'subtitle'           => esc_html__( 'Set the menu font typo for whole theme.', 'utech' ),
                'chosen'             => true,
                'color'              => false,
                'text_align'         => false,
                'text_transform'     => true,
                'letter_spacing'     => true,
                'word_spacing'       => true,
                'font_weight'        => true,
                'line_height'        => true,
                'custom_style'       => true,
                'backup_font_family' => true,
                'unit'               => 'px',
                'preview'            => 'always',
                'output'             => 'ul#nav li a',
                'default'            => array(),
            ),
            array(
                'type'    => 'subheading',
                'content' => esc_html__( 'Menu Color', 'utech' ),
            ),
            array(
                'id'      => 'menu_color',
                'type'    => 'color',
                'title'   => esc_html__( 'Menu Color', 'utech' ),
                'desc'    => esc_html__( 'Set the menu color by color picker', 'utech' ),
                'default' => '#ffffff',
                'output'  => array(),
            ),
            array(
                'id'      => 'menu_hover',
                'type'    => 'color',
                'title'   => esc_html__( 'Menu Hover Color', 'utech' ),
                'desc'    => esc_html__( 'Set the menu hover color by color picker', 'utech' ),
                'default' => '#0045ff',
                'output'  => array(),
            ),
            array(
                'type'    => 'subheading',
                'content' => esc_html__( 'Menu Sticky Color', 'utech' ),
            ),
            array(
                'id'      => 'menu_sticky_color',
                'type'    => 'color',
                'title'   => esc_html__( 'Menu Sticky Color', 'utech' ),
                'desc'    => esc_html__( 'Set the menu sticky color by color picker', 'utech' ),
                'default' => '#00274e',
                'output'  => array(),
            ),
            array(
                'id'      => 'menu_sticky_hover_color',
                'type'    => 'color',
                'title'   => esc_html__( 'Menu Sticky Hover Color', 'utech' ),
                'desc'    => esc_html__( 'Set the menu sticky hover color by color picker', 'utech' ),
                'default' => '#0045ff',
                'output'  => array(),
            ),
            array(
                'type'    => 'subheading',
                'content' => esc_html__( 'Menu Dropdown Color & Hover', 'utech' ),
            ),
            array(
                'id'      => 'menu_dropdown_color',
                'type'    => 'color',
                'title'   => esc_html__( 'Menu Dropdown Color', 'utech' ),
                'desc'    => esc_html__( 'Set the menu dropdown color by color picker', 'utech' ),
                'default' => '#ffffff',
                'output'  => array(),
            ),
            array(
                'id'      => 'menu_dropdown_hover_color',
                'type'    => 'color',
                'title'   => esc_html__( 'Menu Dropdown Hover Color', 'utech' ),
                'desc'    => esc_html__( 'Set the menu dropdown hover color by color picker', 'utech' ),
                'default' => '#0045ff',
                'output'  => array(),
            ),
            array(
                'id'      => 'menu_dropdown_hover_background',
                'type'    => 'color',
                'title'   => esc_html__( 'Menu Dropdown Hover Background Color', 'utech' ),
                'desc'    => esc_html__( 'Set the dropdown background color by color picker', 'utech' ),
                'default' => 'transparent',
                'output'  => array(),
            ),

            array(
                'type'    => 'subheading',
                'content' => esc_html__( 'Menu Dropdown List Style', 'utech' ),
            ),
            array(
                'id'      => 'menu_dropdown_list_background',
                'type'    => 'color',
                'title'   => esc_html__( 'Menu Dropdown List Background Color', 'utech' ),
                'desc'    => esc_html__( 'Set the dropdown list background color by color picker', 'utech' ),
                'output_mode' => 'background-color',
                'default' => '#202030',
                'output'  => 'ul#nav li ul:not(ul#nav li.mega li ul,.mobile ul#nav li.mega li ul,.mobile ul#nav li ul)',
            ),
            array(
                'id'      => 'menu_dropdown_list_border',
                'type'    => 'border',
                'title'   => esc_html__( 'Dropdown List Border', 'utech' ),
                'desc'    => esc_html__( 'Set dropdown list border form here.', 'utech' ),
                'output'  => 'ul#nav li ul:not(ul#nav li.mega li ul,.mobile ul#nav li.mega li ul,.mobile ul#nav li ul)',
                'default' => array(
                    'top'    => '0',
                    'right'  => '0',
                    'bottom' => '3',
                    'left'   => '0',
                    'style'  => 'solid',
                    'color'  => '#0045ff',
                ),
            ),
            array(
                'id'               => 'menu_dropdown_list_border_radius',
                'type'             => 'slider',
                'title'            => esc_html__( 'Dropdown List Border Radius', 'utech' ),
                'desc'             => esc_html__( 'Set dropdown list border radius from here.', 'utech' ),
                'min'              => 0,
                'max'              => 50,
                'step'             => 0.1,
                'unit'             => 'px',
                'default'          => 10,
                'output_mode'      => 'border-radius',
                'output'           => 'ul#nav li ul:not(ul#nav li.mega li ul,.mobile ul#nav li.mega li ul,.mobile ul#nav li ul)',
            ),

            array(
                'type'    => 'subheading',
                'content' => esc_html__( 'Menu Item Animated Border', 'utech' ),
            ),
            array(
                'id'      => 'enable_menu_item_animated_border',
                'type'    => 'switcher',
                'title'   => esc_html__( 'Enable Menu Animated Border', 'utech' ),
                'desc'    => esc_html__( 'If you want to enable or disable animated border in menu item you can set ( YES / NO )', 'utech' ),
                'default' => false,
            ),
            array(
                'id'         => 'menu_item_animated_border_color',
                'type'       => 'color',
                'title'      => esc_html__( 'Menu Animated Border Color', 'utech' ),
                'desc'       => esc_html__( 'Set the menu animated border bottom color by color picker', 'utech' ),
                'default'    => '#f8f8f8',
                'output'     => array( 'background' => 'ul#nav > li.menu-item .wee' ),
                'dependency' => array( 'enable_menu_item_animated_border', '==', 'true' ),
            ),
            array(
                'id'      => 'enable_dropdown_menu_item_animated_border',
                'type'    => 'switcher',
                'title'   => esc_html__( 'Enable Dropdown Menu Animated Border', 'utech' ),
                'desc'    => esc_html__( 'If you want to enable or disable animated border in menu item you can set ( YES / NO )', 'utech' ),
                'default' => false,
            ),
            array(
                'id'         => 'menu_dropdown_item_animated_border_color',
                'type'       => 'color',
                'title'      => esc_html__( 'Menu Dropdown Animated Border Color', 'utech' ),
                'desc'       => esc_html__( 'Set the menu animated border bottom color by color picker', 'utech' ),
                'output'     => array( 'background' => 'ul#nav li ul li a:after' ),
                'dependency' => array( 'enable_dropdown_menu_item_animated_border', '==', 'true' ),
            ),
            array(
                'type'    => 'subheading',
                'content' => esc_html__( 'Menu Area Border Color', 'utech' ),
            ),
            array(
                'id'      => 'menu_border_color',
                'type'    => 'color',
                'title'   => esc_html__( 'Menu Border Color', 'utech' ),
                'desc'    => esc_html__( 'Set the menu border bottom color by color picker', 'utech' ),
                'default' => 'rgba(255,255,255,.15)',
                'output'  => array(),
            ),
        ),
    )
);