<?php

/*-----------------------------------
    GLOBAL DESIGN SECTION
------------------------------------*/
CSF::createSection( UTECH_OPTION_KEY,
    array(
        'title'  => esc_html__( 'Global Design', 'utech' ),
        'parent' => 'General_Tab',
        'icon'   => 'fa fa-magic',
        'fields' => array(
            array(
                'type'    => 'subheading',
                'content' => esc_html__( 'General', 'utech' ),
            ),
            array(
                'id'                    => 'body_background',
                'type'                  => 'background',
                'title'                 => esc_html__( 'Body Background ( Color, Image & Gradient Color )', 'utech' ),
                'subtitle'              => esc_html__( 'Set the body background.', 'utech' ),
                'desc'                  => esc_html__( 'Set the body background color, image and gradient color. If you set only first color field it will be a simple solid color for background and if set 2nd color field too it will be set a gradient color and if you set a image it will be set a background image.', 'utech' ),
                'background_image'      => true,
                'background_position'   => true,
                'background_repeat'     => true,
                'background_attachment' => true,
                'background_size'       => true,
                'background_gradient'   => true,
                'background_origin'     => true,
                'background_clip'       => true,
                'background_blend_mode' => true,
                'output'                => 'body',
            ),
            array(
                'id'      => 'body_link_color',
                'type'    => 'link_color',
                'title'   => esc_html__( 'Link Color & Hover Color', 'utech' ),
                'output'  => 'a',
            ),
            array(
                'type'    => 'subheading',
                'content' => esc_html__( 'Post Items', 'utech' ),
            ),
            array(
                'id'                    => 'post_item_background',
                'type'                  => 'background',
                'title'                 => esc_html__( 'Post Item Background', 'utech' ),
                'subtitle'              => esc_html__( 'Set the post background.', 'utech' ),
                'desc'                  => esc_html__( 'Set the post background color, image and gradient color. If you set only first color field it will be a simple solid color for background and if set 2nd color field too it will be set a gradient color and if you set a image it will be set a background image.', 'utech' ),
                'background_image'      => true,
                'background_position'   => true,
                'background_repeat'     => true,
                'background_attachment' => true,
                'background_size'       => true,
                'background_gradient'   => true,
                'background_origin'     => true,
                'background_clip'       => true,
                'background_blend_mode' => true,
                'output'                => '.single-post-item .post-details',
            ),
            array(
                'id'     => 'post_item_border',
                'type'   => 'border',
                'title'  => esc_html__( 'Post Item Border', 'utech' ),
                'output' => '.single-post-item .post-details'
            ),
            array(
                'id'      => 'post_item_readmore_color',
                'type'    => 'link_color',
                'title'   => esc_html__( 'Readmore Color & Hover Color', 'utech' ),
                'output'  => '.posts__readmore a',
            ),
            array(
                'id'      => 'post_author_color',
                'type'    => 'link_color',
                'title'   => esc_html__( 'Author Color & Hover Color', 'utech' ),
                'output'  => '.post__author a',
            ),
            array(
                'id'      => 'post_meta',
                'type'    => 'link_color',
                'title'   => esc_html__( 'Meta Color & Hover Color', 'utech' ),
                'output'  => '.single__random__category a',
            ),
            array(
                'id'                    => 'post_item_meta_background',
                'type'                  => 'background',
                'title'                 => esc_html__( 'Post Item Meta Background', 'utech' ),
                'subtitle'              => esc_html__( 'Set the post meta background.', 'utech' ),
                'desc'                  => esc_html__( 'Set the post meta background color, image and gradient color. If you set only first color field it will be a simple solid color for background and if set 2nd color field too it will be set a gradient color and if you set a image it will be set a background image.', 'utech' ),
                'background_image'      => true,
                'background_position'   => true,
                'background_repeat'     => true,
                'background_attachment' => true,
                'background_size'       => true,
                'background_gradient'   => true,
                'background_origin'     => true,
                'background_clip'       => true,
                'background_blend_mode' => true,
                'output'                => '.single__random__category a',
            ),
            array(
                'id'                    => 'post_item_meta_hover_background',
                'type'                  => 'background',
                'title'                 => esc_html__( 'Post Item Meta Hover Background', 'utech' ),
                'subtitle'              => esc_html__( 'Set the post meta hover background.', 'utech' ),
                'desc'                  => esc_html__( 'Set the post meta hover background color, image and gradient color. If you set only first color field it will be a simple solid color for background and if set 2nd color field too it will be set a gradient color and if you set a image it will be set a background image.', 'utech' ),
                'background_image'      => true,
                'background_position'   => true,
                'background_repeat'     => true,
                'background_attachment' => true,
                'background_size'       => true,
                'background_gradient'   => true,
                'background_origin'     => true,
                'background_clip'       => true,
                'background_blend_mode' => true,
                'output'                => '.single__random__category a:hover',
            ),
            array(
                'type'    => 'subheading',
                'content' => esc_html__( 'Sidebar Widgets', 'utech' ),
            ),
            array(
                'id'                    => 'sidebar_widget_background',
                'type'                  => 'background',
                'title'                 => esc_html__( 'Sidebar Widget Background', 'utech' ),
                'subtitle'              => esc_html__( 'Set the sidebar widget background.', 'utech' ),
                'desc'                  => esc_html__( 'Set the sidebar widget background color, image and gradient color. If you set only first color field it will be a simple solid color for background and if set 2nd color field too it will be set a gradient color and if you set a image it will be set a background image.', 'utech' ),
                'background_image'      => true,
                'background_position'   => true,
                'background_repeat'     => true,
                'background_attachment' => true,
                'background_size'       => true,
                'background_gradient'   => true,
                'background_origin'     => true,
                'background_clip'       => true,
                'background_blend_mode' => true,
                'output'                => '.blog__widgets__wrap .single-widgets',
            ),
            array(
                'id'     => 'sidebar_widget_border',
                'type'   => 'border',
                'title'  => esc_html__( 'Widget Border', 'utech' ),
                'output' => '.blog__widgets__wrap .single-widgets'
            ),
            array(
                'id'     => 'sidebar_widget_heading',
                'type'   => 'color',
                'title'  => esc_html__( 'Widget Title', 'utech' ),
                'output' => '.blog__widgets__wrap .widget-title h3'
            ),
            array(
                'id'          => 'sidebar_widget_heading_before',
                'type'        => 'color',
                'title'       => esc_html__( 'Widget Title Before', 'utech' ),
                'output_mode' => 'background',
                'output'      => '.blog__widgets__wrap .widget-title h3:before'
            ),
            array(
                'id'     => 'sidebar_widget_heading_border',
                'type'   => 'border',
                'title'  => esc_html__( 'Widget Title Border', 'utech' ),
                'output' => '.blog__widgets__wrap .widget-title h3'
            ),
            array(
                'id'      => 'sidebar_widget_link_color',
                'type'    => 'link_color',
                'title'   => esc_html__( 'Widget link Color', 'utech' ),
                'output'  => '.blog__widgets__wrap .single-widgets a',
            ),
        ),
    )
);