<?php

/*-----------------------------------
RELATED PRODUCTS LOOP
------------------------------------*/
CSF::createSection( UTECH_OPTION_KEY,
    array(
        'parent' => 'WooCommerce_Tab',
        'title'  => esc_html__( 'Upsells Products', 'utech' ),
        'icon'   => 'fa fa-grip-horizontal',
        'fields' => array(

            array(
                'type'    => 'subheading',
                'content' => esc_html__( 'Upsells Product Setting', 'utech' ),
            ),
            array(
                'id'      => 'enable_upsells_product',
                'type'    => 'switcher',
                'title'   => esc_html__( 'Show Upsells Products', 'utech' ),
                'desc'    => esc_html__( 'If you want to set upsells products you can set ( YES / NO )', 'utech' ),
                'default' => true,
            ),

            array(
                'id'         => 'enable_upsells_product_custom_heading',
                'type'       => 'switcher',
                'title'      => esc_html__( 'Upsells Product Custom Heading?', 'utech' ),
                'desc'       => esc_html__( 'If you want to set custom title you can set ( YES / NO )', 'utech' ),
                'default'    => false,
                'dependency' => array( 'enable_upsells_product', '==', 'true' ),
            ),
            array(
                'id'         => 'upsells_product_custom_title',
                'type'       => 'text',
                'title'      => esc_html__( 'Upsells Product Custom Heading', 'utech' ),
                'desc'       => esc_html__( 'Set your preferred custom upsells products title.', 'utech' ),
                'default'    => esc_html__( 'You may like also', 'utech' ),
                'dependency' => array( 'enable_upsells_product_custom_heading|enable_upsells_product', '==|==', 'true|true' ),
            ),
            array(
                'id'         => 'enable_upsells_product_slider',
                'type'       => 'switcher',
                'title'      => esc_html__( 'Upsells Product Slider?', 'utech' ),
                'desc'       => esc_html__( 'If you want to set slider in upsells products you can set ( YES / NO )', 'utech' ),
                'default'    => true,
                'dependency' => array( 'enable_upsells_product', '==', 'true' ),
            ),

            array(
                'type'       => 'subheading',
                'content'    => esc_html__( 'Upsells Product Loop Settings', 'utech' ),
                'dependency' => array( 'enable_upsells_product', '==', 'true' ),
            ),
            array(
                'id'         => 'upsells_product_per_page',
                'type'       => 'slider',
                'title'      => esc_html__( 'Upsells Product Per Page', 'utech' ),
                'desc'       => esc_html__( 'Set the upsells product per page in all single product pages.', 'utech' ),
                'min'        => 1,
                'max'        => 100,
                'step'       => 1,
                'unit'       => '',
                'default'    => 6,
                'dependency' => array( 'enable_upsells_product', '==', 'true' ),
            ),
            array(
                'id'         => 'upsells_product_per_row',
                'type'       => 'slider',
                'title'      => esc_html__( 'Upsells Product Per Row', 'utech' ),
                'desc'       => esc_html__( 'Set the upsells product per row in all single product pages.', 'utech' ),
                'min'        => 1,
                'max'        => 6,
                'step'       => 1,
                'unit'       => '',
                'default'    => 3,
                'dependency' => array( 'enable_upsells_product', '==', 'true' ),
            ),
        ),
    )
);