<?php

/*-----------------------------------
    BANNER SECTION
------------------------------------*/
CSF::createSection( UTECH_OPTION_KEY,
    array(
        'title'  => esc_html__( 'Banner', 'utech' ),
        'parent' => 'General_Tab',
        'icon'   => 'fa fa-credit-card',

        'fields' => array(
            array(
                'type'    => 'subheading',
                'content' => esc_html__( 'Banner Height', 'utech' ),
            ),
            array(
                'id'          => 'banner_area_height',
                'type'        => 'slider',
                'title'       => esc_html__( 'Banner Area Height', 'utech' ),
                'desc'        => esc_html__( 'Set the main banner area max height, default is 400 and max value is 500 in decimal', 'utech' ),
                'min'         => 1,
                'max'         => 500,
                'step'        => 1,
                'unit'        => 'px',
                'output_mode' => 'max-height',
                'output'      => '.banner-area',
            ),

            array(
              'type'    => 'subheading',
              'content' => esc_html__( 'Banner Image', 'utech' ),
            ),
            array(
                'id'                    => 'banner_background',
                'type'                  => 'background',
                'title'                 => esc_html__( 'Banner Background', 'utech' ),
                'subtitle'              => esc_html__( 'Set the Banner background.', 'utech' ),
                'desc'                  => esc_html__( 'Set the Banner background color, image and gradient color. If you set only first color field it will be a simple solid color for background and if set 2nd color field too it will be set a gradient color and if you set a image it will be set a background image.', 'utech' ),
                'background_image'      => true,
                'background_position'   => true,
                'background_repeat'     => true,
                'background_attachment' => true,
                'background_size'       => true,
                'background_gradient'   => true,
                'background_origin'     => true,
                'background_clip'       => true,
                'background_blend_mode' => true,
                'output'                => '.banner-area-bg',
                'default'               => array(
                    'background-repeat'     => 'no-repeat',
                    'background-attachment' => 'scroll',
                    'background-position'   => 'center center',
                    'background-size'       => 'cover',
                )
            ),

            array(
              'type'    => 'subheading',
              'content' => esc_html__( 'Banner Overlay', 'utech' ),
            ),
            array(
                'id'                    => 'banner_overlay_background',
                'type'                  => 'background',
                'title'                 => esc_html__( 'Banner Background Overlay', 'utech' ),
                'subtitle'              => esc_html__( 'Set the banner background overlay.', 'utech' ),
                'desc'                  => esc_html__( 'Set the banner background overlay color, image and gradient color. If you set only first color field it will be a simple solid color for background and if set 2nd color field too it will be set a gradient color and if you set a image it will be set a background image.', 'utech' ),
                'background_image'      => true,
                'background_position'   => true,
                'background_repeat'     => true,
                'background_attachment' => true,
                'background_size'       => true,
                'background_gradient'   => true,
                'background_origin'     => true,
                'background_clip'       => true,
                'background_blend_mode' => true,
                'output'                => '.banner-area-bg:after',
            ),
            array(
                'id'    => 'banner_overlay_opacity',
                'type'  => 'slider',
                'title' => esc_html__( 'Banner Overlay Opacity', 'utech' ),
                'desc'  => esc_html__( 'Set the main Banner overlay opacity max value is 1 in decimal', 'utech' ),
                'min'   => 0,
                'max'   => 1,
                'step'  => 0.01,
                'unit'  => ' ',
                //'default'     => 0.5,
                'output_mode' => 'opacity',
                'output'      => '.banner-area-bg:after',
            ),

            array(
                'type'    => 'subheading',
                'content' => esc_html__( 'Banner Text Align', 'utech' ),
            ),
            array(
                'id'      => 'header_text_align',
                'type'    => 'select',
                'title'   => esc_html__( 'Text Align', 'utech' ),
                'desc'    => esc_html__( 'Set the header text alignment ( Left / Right / Center )', 'utech' ),
                'options' => array(
                    'left'   => esc_html__( 'Left', 'utech' ),
                    'center' => esc_html__( 'Center', 'utech' ),
                    'right'  => esc_html__( 'Right', 'utech' ),
                ),
                'default' => 'center',
            ),

            array(
                'type'    => 'subheading',
                'content' => esc_html__( 'Heading Text', 'utech' ),
            ),
            array(
                'id'      => 'header_textcolor',
                'type'    => 'color',
                'title'   => esc_html__( 'Text Color', 'utech' ),
                'desc'    => esc_html__( 'Set the header text color by color picker. NOTE: You can also change header text color form customizer panel.', 'utech' ),
                'default' => '#ffffff',
                'output'  => array( '.banner-area', '.page-title h1', '.page-title' ),
            ),

            array(
                'type'    => 'subheading',
                'content' => esc_html__( 'Breadcrumb', 'utech' ),
            ),
            array(
                'id'      => 'enable_breadcrumb_root_text',
                'type'    => 'switcher',
                'title'   => esc_html__( 'Breadcrumb Root Text', 'utech' ),
                'desc'    => esc_html__( 'If you want to set cutom root text in breadcrumb then you can set ( YES / NO )', 'utech' ),
                'default' => false,
            ),
            array(
                'id'         => 'breadcrumb_home_text',
                'type'       => 'text',
                'title'      => esc_html__( 'Custom Root Text', 'utech' ),
                'desc'       => esc_html__( 'Set the breadcrumb starting custom root text here by default is Home.', 'utech' ),
                'dependency' => array( 'enable_breadcrumb_root_text', '==', 'true' ),
                'default'    => 'Home',
            ),
            array(
                'id'         => 'header_breadcrumb_textcolor',
                'type'       => 'color',
                'title'      => esc_html__( 'Text Color', 'utech' ),
                'desc'       => esc_html__( 'Set the header text color by color picker. NOTE: You can also change header text color form customizer panel.', 'utech' ),
                'default'    => '#ffffff',
                'output'     => array( '.breadcumb', '.breadcumb a', '.breadcumb a span', '.breadcumb span', '.breadcumb span.active' ),
            ),
            array(
                'id'      => 'header_link_color',
                'type'    => 'link_color',
                'title'   => esc_html__( 'links color', 'utech' ),
                'desc'    => esc_html__( 'Set the header banner area link color & hover color.', 'utech' ),
                'output'  => array( '.banner-area a', '.banner-area .breadcumb a', '.banner-area .breadcumb a span','.breadcumb span', '.breadcumb span.active' ),
                'default' => array(
                    'color' => '#ffffff',
                    'hover' => '#ffffff',
                ),
            ),
            array(
                'id'         => 'header_link_active_color',
                'type'       => 'color',
                'title'      => esc_html__( 'Link Active Color', 'utech' ),
                'desc'       => esc_html__( 'Set the header banner area link active color by color picker. NOTE: You can also change header text color form customizer panel.', 'utech' ),
                'default'    => '#ffffff',
                'output'     => array( '.banner-area .breadcumb span.active:last-child' ),
            ),
        ),
    )
);