<?php 

/*-----------------------------------
    PRE LOADER SECTION
------------------------------------*/
CSF::createSection( UTECH_OPTION_KEY,
	array(
		'title'  => esc_html__( 'Preloader', 'utech' ),
		'icon'   => 'fa fa-spinner fa-pulse',
		'fields' => array(
			array(
				'type'    => 'subheading',
				'content' => esc_html__( 'Preloader ON / OFF', 'utech' ),
			),
			array(
				'id'      => 'enable_preloader',
				'type'    => 'switcher',
				'title'   => esc_html__( 'Enable Preloader', 'utech' ),
				'desc'    => esc_html__( 'If you want to enable or disable preloader you can set ( YES / NO )', 'utech' ),
				'default' => true,
			),
			array(
				'id'         => 'enable_custom_preloader',
				'type'       => 'switcher',
				'title'      => esc_html__( 'Add Custom Preloader ?', 'utech' ),
				'desc'       => esc_html__( 'If you want to add custom image for preloader you can set ( YES / NO )', 'utech' ),
				'default'    => false,
				'dependency' => array( 'enable_preloader', '==', 'true' ),
			),
			array(
				'id'         => 'add_preloader_image',
				'type'       => 'media',
				'title'      => esc_html__( 'Add Custom Image', 'utech' ),
				'desc'       => esc_html__( 'Add the custom image for preloader.', 'utech' ),
				'library'    => 'image',
				'dependency' => array( 'enable_preloader|enable_custom_preloader', '==|', 'true|true' ),
			),		
			array(
				'id'      => 'preloader_style',
				'type'    => 'image_select',
				'class'   => 'preloader_section',
				'title'   => esc_html__( 'Select Preloader Style', 'utech' ),
				'desc'    => esc_html__( 'You can set specific preloader style in every page form here.', 'utech' ),
				'options' => array(
					'style_3'  => UTECH_ROOT_IMAGE .'/loader/loader_3.png',
					'style_4'  => UTECH_ROOT_IMAGE .'/loader/loader_horizontal.gif',
					'style_5'  => UTECH_ROOT_IMAGE .'/loader/loader_spinner.gif',
					'style_6'  => UTECH_ROOT_IMAGE .'/loader/loader_spinner.svg',
					'style_7'  => UTECH_ROOT_IMAGE .'/loader/loader_square_circle.gif',
					'style_8'  => UTECH_ROOT_IMAGE .'/loader/loader_wave.gif',
					'style_9'  => UTECH_ROOT_IMAGE .'/loader/loeader_square.gif',
					'style_10' => UTECH_ROOT_IMAGE .'/loader/wave_preloader.svg',
					'style_11' => UTECH_ROOT_IMAGE .'/loader/ajax_loader.svg',
					'style_12' => UTECH_ROOT_IMAGE .'/loader/audio.svg',
					'style_13' => UTECH_ROOT_IMAGE .'/loader/ball_triangle.svg',
					'style_14' => UTECH_ROOT_IMAGE .'/loader/bars.svg',
					'style_15' => UTECH_ROOT_IMAGE .'/loader/circle_pulse_rings.svg',
					'style_16' => UTECH_ROOT_IMAGE .'/loader/circle_tail_spin.svg',
					'style_17' => UTECH_ROOT_IMAGE .'/loader/circles.svg',
					'style_18' => UTECH_ROOT_IMAGE .'/loader/flip_circle.svg',
					'style_19' => UTECH_ROOT_IMAGE .'/loader/grid.svg',
					'style_20' => UTECH_ROOT_IMAGE .'/loader/heart.svg',
					'style_21' => UTECH_ROOT_IMAGE .'/loader/hearts_group.svg',
					'style_22' => UTECH_ROOT_IMAGE .'/loader/horizontal_loader_2.svg',
					'style_23' => UTECH_ROOT_IMAGE .'/loader/road_cross.svg',
					'style_24' => UTECH_ROOT_IMAGE .'/loader/round_circle.svg',
					'style_25' => UTECH_ROOT_IMAGE .'/loader/round_pulse.svg',
					'style_26' => UTECH_ROOT_IMAGE .'/loader/simple_spainer.svg',
					'style_27' => UTECH_ROOT_IMAGE .'/loader/spinner.svg',
					'style_28' => UTECH_ROOT_IMAGE .'/loader/spinning_circles.svg',
					'style_29' => UTECH_ROOT_IMAGE .'/loader/three_dots.svg',
				),
				'default'    => 'style_22',
				'dependency' => array( 'enable_preloader|enable_custom_preloader', '==|==', 'true|false' ),
			),
			array(
				'type'       => 'subheading',
				'content'    => esc_html__( 'Preloader Background & Color', 'utech' ),
				'dependency' => array( 'enable_preloader', '==', 'true' ),
			),
			array(
				'id'                    => 'preloader_bg',
				'type'                  => 'background',
				'title'                 => esc_html__( 'Preloader Background', 'utech' ),
				'subtitle'              => esc_html__( 'Set the preloader background.', 'utech' ),
				'desc'                  => esc_html__( 'Set the preloader background color, image, transparent image and gradient color. If you set only first color field it will be a simple solid color for background and if set 2nd color field too it will be set a gradient color and if you set a image it will be set a background image.', 'utech' ),
				'background_image'      => true,
				'background_position'   => true,
				'background_repeat'     => true,
				'background_attachment' => true,
				'background_size'       => true,
				'background_gradient'   => true,
				'background_origin'     => true,
				'background_clip'       => true,
				'background_blend_mode' => true,
				'output'                => '.preeloader',
				'default'               => array(
					'background-color'              => '#ffffff',
					'background-size'               => 'cover',
					'background-position'           => 'center center',
					'background-repeat'             => 'repeat',
				),
				'dependency' => array( 'enable_preloader', '==', 'true' ),
			),
            array(
				'id'         => 'preloader_text_color',
				'type'       => 'color',
				'title'      => esc_html__( 'Preloader Text Color', 'utech' ),
				'desc'       => esc_html__( 'Set the preloader text color', 'utech' ),
				'default'    => '#0045ff',
				'output'     => array( '.preeloader','.preloader-spinner' ),
				'dependency' => array( 'enable_preloader', '==', 'true' ),
            ),
	    ),
	)
);