<?php

/*-----------------------------------
    LOGO SECTION
------------------------------------*/
CSF::createSection( UTECH_OPTION_KEY,
    array(
        'parent' => 'Header_Tab',
        'title'  => esc_html__( 'Logo Upload', 'utech' ),
        'icon'   => 'fa fa-image',
        'fields' => array(

            array(
                'type'    => 'subheading',
                'content' => esc_html__( 'Main Image Logo', 'utech' ),
            ),
            array(
                'id'      => 'logo',
                'type'    => 'media',
                'title'   => esc_html__( 'Main Logo', 'utech' ),
                'desc'    => esc_html__( 'Upload main logo width 180px and height 65px.', 'utech' ),
                'default' => '',
                'library' => 'image',
                'preview' => true,
                'url'     => false,
                'help'    => esc_html__( 'Note: Please use logo image max width: 250px and max height 100px.', 'utech' ),
            ),
            array(
                'id'      => 'sticky_logo',
                'type'    => 'media',
                'title'   => esc_html__( 'Sticky Logo', 'utech' ),
                'desc'    => esc_html__( 'Upload sticky logo width 180px and height 65px.', 'utech' ),
                'default' => '',
                'library' => 'image',
                'preview' => true,
                'url'     => false,
                'help'    => esc_html__( 'Note: Please use logo image max width: 250px and max height 100px.', 'utech' ),
            ),
            array(
                'id'            => 'logo_height_width',
                'type'          => 'dimensions',
                'title'         => esc_html__( 'Logo Max Height & Max Width.', 'utech' ),
                'desc'          => esc_html__( 'If no need to fill any data ( like: height or width ) then you can empty the field.', 'utech' ),
                'output_prefix' => 'max',
                'output'        => '.mainmenu-area .custom-logo-link img,.mainmenu-area .custom-logo-link svg'
            ),
            array(
                'type'    => 'subheading',
                'content' => esc_html__( 'Text Logo Color', 'utech' ),
            ),
            array(
                'id'      => 'logo_color',
                'type'    => 'color',
                'title'   => esc_html__( 'Text Logo Color', 'utech' ),
                'desc'    => esc_html__( 'Set the text logo color by color picker.', 'utech' ),
                'default' => '#ffffff',
                'output'  => array(),
            ),
            array(
                'id'      => 'sticky_logo_color',
                'type'    => 'color',
                'title'   => esc_html__( 'Sticky Text Logo Color', 'utech' ),
                'desc'    => esc_html__( 'Set the text logo sticky color by color picker.', 'utech' ),
                'default' => '#00152e',
                'output'  => array(),
            ),
            array(
                'type'    => 'subheading',
                'content' => esc_html__( 'Mobile Text Logo Color', 'utech' ),
            ),
            array(
                'id'      => 'mobile_logo_color',
                'type'    => 'color',
                'title'   => esc_html__( 'Text Logo Color On Mobile', 'utech' ),
                'desc'    => esc_html__( 'Set the text logo color by color picker.', 'utech' ),
                'default' => '#00152e',
                'output'  => array(),
            ),
            array(
                'id'      => 'mobile_sticky_logo_color',
                'type'    => 'color',
                'title'   => esc_html__( 'Sticky Text Logo Color On Mobile', 'utech' ),
                'desc'    => esc_html__( 'Set the text logo sticky color by color picker.', 'utech' ),
                'default' => '#0045ff',
                'output'  => array(),
            ),
        )
    )
);