<?php

/*-----------------------------------
    SINGLE PRODUCT PAGE
------------------------------------*/
CSF::createSection( UTECH_OPTION_KEY,
    array(
        'parent' => 'WooCommerce_Tab',
        'title'  => esc_html__( 'Single Product Page', 'utech' ),
        'icon'   => 'fa fa-shopping-bag',
        'fields' => array(

            array(
                'type'    => 'subheading',
                'content' => esc_html__( 'Single Product Page Setting', 'utech' ),
            ),
            array(
                'id'      => 'enable_product_custom_title',
                'type'    => 'switcher',
                'title'   => esc_html__( 'Custom Prodcut Barner Title?', 'utech' ),
                'desc'    => esc_html__( 'If you want to set custom barner title you can set ( YES / NO )', 'utech' ),
                'default' => false,
            ),
            array(
                'id'         => 'product_custom_title',
                'type'       => 'text',
                'title'      => esc_html__( 'Product Barner Custom Title', 'utech' ),
                'desc'       => esc_html__( 'Set your preferred custom product barner title.', 'utech' ),
                'default'    => esc_html__( 'Product Details', 'utech' ),
                'dependency' => array( 'enable_product_custom_title', '==', 'true' ),
            ),

            array(
                'id'      => 'desable_product_title_from_summary',
                'type'    => 'switcher',
                'title'   => esc_html__( 'Remove Title From Summary?', 'utech' ),
                'desc'    => esc_html__( 'If you want to remove product title from summary you can set ( YES / NO )', 'utech' ),
                'default' => false,
            ),

            array(
                'id'      => 'change_cart_button_text_single_product',
                'type'    => 'switcher',
                'title'   => esc_html__( 'Change Add To Cart Button Text?', 'utech' ),
                'desc'    => esc_html__( 'If you want to add to cart button text you can set ( YES / NO )', 'utech' ),
                'default' => false,
            ),
            array(
                'id'         => 'cart_button_text_single_product',
                'type'       => 'text',
                'title'      => esc_html__( 'Add To Cart Button Text', 'utech' ),
                'desc'       => esc_html__( 'Set the custom add to cart button text.', 'utech' ),
                'default'    => 'Buy now',
                'dependency' => array( 'change_cart_button_text_single_product', '==', 'true' ),
            ),

            array(
                'id'      => 'change_variable_single_product_custom_cart_button_text',
                'type'    => 'switcher',
                'title'   => esc_html__( 'Change Variable Product Add To Cart Button Text?', 'utech' ),
                'desc'    => esc_html__( 'If you want to add to cart button text you can set ( YES / NO )', 'utech' ),
                'default' => false,
            ),
            array(
                'id'         => 'variable_single_product_custom_cart_button_text',
                'type'       => 'text',
                'title'      => esc_html__( 'Variable Product Add To Cart Button Text', 'utech' ),
                'desc'       => esc_html__( 'Set the custom add to cart button text for variable product.', 'utech' ),
                'default'    => 'Buy now',
                'dependency' => array( 'change_variable_single_product_custom_cart_button_text', '==', 'true' ),
            ),

            array(
                'id'      => 'add_buy_now_in_single_product',
                'type'    => 'switcher',
                'title'   => esc_html__( 'Add Buy Now Button In Single Product ?', 'utech' ),
                'desc'    => esc_html__( 'If you want to add buy now button in single product page then you can set ( YES / NO )', 'utech' ),
                'default' => false,
            ),
            array(
                'id'         => 'buy_now_in_single_product_text',
                'type'       => 'text',
                'title'      => esc_html__( 'Custom Buy Now Text', 'utech' ),
                'desc'       => esc_html__( 'Set the custom buy now text for product single page.', 'utech' ),
                'default'    => 'Buy Now',
                'dependency' => array( 'add_buy_now_in_single_product', '==', 'true' ),
            ),
            
            array(
                'id'      => 'disable_buy_now_button_in_varable_product',
                'type'    => 'switcher',
                'title'   => esc_html__( 'Disable Buy Now Button In Variable Single Product ?', 'utech' ),
                'desc'    => esc_html__( 'If you want to disable buy now button in variable single product page then you can set ( YES / NO )', 'utech' ),
                'default' => true,
                'dependency' => array( 'add_buy_now_in_single_product', '==', 'true' ),
            ),
        ),
    )
);