<?php

/*-----------------------------------
    FOOTER TOP SECTION
------------------------------------*/
CSF::createSection( UTECH_OPTION_KEY,
    array(
        'parent' => 'Footer_Tab',
        'title'  => esc_html__( 'Footer Top', 'utech' ),
        'icon'   => 'fa fa-th',
        'fields' => array(

            array(
                'type'    => 'subheading',
                'content' => esc_html__( 'Footer Top Columns Layout', 'utech' ),
            ),
            array(
                'id'      => 'footer_top_columns',
                'type'    => 'image_select',
                'title'   => esc_html__( 'Footer Top Columns', 'utech' ),
                'desc'    => esc_html__( 'You can chose and select footer layout style type from here..', 'utech' ),
                'options' => array(
                    'one'   => UTECH_ROOT_IMAGE . '/footer/footer_1.png',
                    'two'   => UTECH_ROOT_IMAGE . '/footer/footer_2.png',
                    'three' => UTECH_ROOT_IMAGE . '/footer/footer_3.png',
                    'four'  => UTECH_ROOT_IMAGE . '/footer/footer_4.png',
                    'five'  => UTECH_ROOT_IMAGE . '/footer/footer_5.png',
                    'six'   => UTECH_ROOT_IMAGE . '/footer/footer_6.png',
                    'seven' => UTECH_ROOT_IMAGE . '/footer/footer_7.png',
                    'eight' => UTECH_ROOT_IMAGE . '/footer/footer_8.png',
                    'nine'  => UTECH_ROOT_IMAGE . '/footer/footer_9.png',
                ),
                'default' => 'four',
            ),

            array(
                'type'    => 'subheading',
                'content' => esc_html__( 'Footer Text Color', 'utech' ),
            ),
            array(
                'id'      => 'footer_text_color',
                'type'    => 'color',
                'title'   => esc_html__( 'Footer Text Color', 'utech' ),
                'desc'    => esc_html__( 'Set footer text color form here.', 'utech' ),
                'default' => '#c2d1e2',
                'output'  => '.footer-area'
            ),
            array(
                'type'    => 'subheading',
                'content' => esc_html__( 'Footer Link Color', 'utech' ),
            ),
            array(
                'id'               => 'footer_link_color',
                'type'             => 'link_color',
                'title'            => esc_html__( 'Footer links color', 'utech' ),
                'desc'             => esc_html__( 'Set the footer area link color & hover color.', 'utech' ),
                'output'           => array('.footer-top a','.footer-area .widget_pages ul li a', '.footer-area .widget_nav_menu ul li a'),
                'output_important' => true,
                'default'          => array(
                    'color' => '#ffffff',
                    'hover' => '#0045ff',
                ),
            ),
            array(
                'type'    => 'subheading',
                'content' => esc_html__( 'Footer Heading Color', 'utech' ),
            ),
            array(
                'id'      => 'heading_color',
                'type'    => 'color',
                'title'   => esc_html__( 'Footer Heading Color', 'utech' ),
                'desc'    => esc_html__( 'Set footer footer heading color form here.', 'utech' ),
                'default' => '#ffffff',
                'output'  => array( '.footer-area h1','.footer-area h2','.footer-area h3','.footer-area h4','.footer-area h5','.footer-area h6' ),
            ),

            array(
                'id'      => 'heading_border_color',
                'type'    => 'color',
                'title'   => esc_html__( 'Footer Heading Border Color', 'utech' ),
                'desc'    => esc_html__( 'Set footer footer heading border color form here.', 'utech' ),
                'default' => '#ffffff',
                'output'  => array( 'border-color' => '.footer-area h3' ),
            ),

            array(
                'id'      => 'heading_before_after_color',
                'type'    => 'color',
                'title'   => esc_html__( 'Footer Heading Before / After Color', 'utech' ),
                'desc'    => esc_html__( 'Set footer footer heading before / after color form here.', 'utech' ),
                'default' => '#ffffff',
                'output'  => array( 'background' => '.footer-area h3:before,.footer-area h3:after' ),
            ),
        ),
    )
);