<?php
CSF::createSection( UTECH_OPTION_KEY,
    array(
        'icon'   => 'fa fa-book',
        'title'  => 'Blog',
        'fields' => array(
            array(
                'id'      => 'blog_layout',
                'type'    => 'image_select',
                'title'   => esc_html__( 'Blog layout', 'utech' ),
                'desc'    => esc_html__( 'Select the Blog style which you want to show on your website.', 'utech' ),
                'options' => array(
                    'default' => UTECH_ROOT_IMAGE . '/admin/blog/default.png',
                    'style1'  => UTECH_ROOT_IMAGE . '/admin/blog/layout-1.png',

                ),
                'default' => 'default',
            ),
            array(
                'id'          => 'blog_sidebar',
                'type'        => 'select',
                'title'       => esc_html__( 'Blog Sidebar', 'utech' ),
                'placeholder' => 'Select an option',
                'options'     => array(
                    '1' => esc_html__( 'No sidebar', 'utech' ),
                    '2' => esc_html__( 'Left Sidebar', 'utech' ),
                    '3' => esc_html__( 'Right Sidebar', 'utech' ),
                ),
                'default'     => '3',
            ),
            array(
                'id'      => 'blog_author',
                'type'    => 'switcher',
                'title'   => esc_html__( 'Blog Author', 'utech' ),
                'default' => true,
            ),

            array(
                'id'      => 'blog_author_image',
                'type'    => 'switcher',
                'title'   => esc_html__( 'Blog Author image', 'utech' ),
                'default' => false,
            ),

            array(
                'id'      => 'blog_date',
                'type'    => 'switcher',
                'title'   => esc_html__( 'Blog Date', 'utech' ),
                'default' => true,
            ),

            array(
                'id'      => 'blog_comment',
                'type'    => 'switcher',
                'title'   => esc_html__( 'Blog Comment', 'utech' ),
                'default' => true,
            ),

            array(
                'id'      => 'blog_category',
                'type'    => 'switcher',
                'title'   => esc_html__( 'Blog Category', 'utech' ),
                'default' => true,
            ),

            array(
                'id'      => 'blog_category_single',
                'type'    => 'switcher',
                'title'   => esc_html__( 'Blog Category Single', 'utech' ),
                'default' => false,
            ),
            array(
                'id'      => 'blog_readmore',
                'type'    => 'switcher',
                'title'   => esc_html__( 'Blog Readmore', 'utech' ),
                'default' => true,
            ),
            array(
                'id'      => 'blog_readmore_text',
                'type'    => 'text',
                'title'   => esc_html__( 'Blog Readmore Text', 'utech' ),
                'default' => esc_html__( 'Read More', 'utech' ),
            ),
            array(
                'id'      => 'blog_post_nav',
                'type'    => 'switcher',
                'title'   => esc_html__( 'Blog Navigation', 'utech' ),
                'default' => true,
            ),
            array(
                'type'    => 'subheading',
                'content' => esc_html__( 'Blog & Page Default Options', 'utech' ),
            ),
            array(
                'id'      => 'blog_excerpt_word',
                'type'    => 'number',
                'title'   => esc_html__( 'Blog Excerpt Word', 'utech' ),
                'desc'    => esc_html__( 'Set the words that how many words you want to show in every blog post item.', 'utech' ),
                'default' => '30',
            ),
        ),
    )
);