<?php

/*-----------------------------------
    MOBILE MENU SECTION
------------------------------------*/
$info       = wp_get_theme();
$author_uri = $info->get( 'AuthorURI' );
CSF::createSection( UTECH_OPTION_KEY,
    array(
        'parent' => 'Header_Tab',
        'title'  => esc_html__( 'Mobile Menu', 'utech' ),
        'icon'   => 'fa fa-tablet',
        'fields' => array(

            array(
                'type'    => 'subheading',
                'content' => esc_html__( 'Mobile Menu Layout & Menu Open Buttons', 'utech' ),
            ),
            array(
                'id'      => 'mobile_menu_style',
                'type'    => 'select',
                'title'   => esc_html__( 'Mobile Menu Layout', 'utech' ),
                'desc'    => esc_html__( 'Set the mobile menu style form here.', 'utech' ),
                'options' => array(
                    'static' => esc_html__( 'Menu Position Top', 'utech' ),
                    'left'   => esc_html__( 'Menu Position Left', 'utech' ),
                    'right'  => esc_html__( 'Menu Position Right', 'utech' ),
                    'offcanvas'  => esc_html__( 'Menu Offcanvas', 'utech' ),
                ),
                'default' => 'center',
            ),
            array(
                'id'         => 'contact_number',
                'type'       => 'text',
                'title'      => esc_html__( 'Contact Phone', 'utech' ),
                'desc'       => esc_html__( 'Set the mobile menu contact phone no.', 'utech' ),
                'default'    => '+0001234567890',
                'dependency' => array( 'mobile_menu_style', 'any', 'left,right' ),
            ),
            array(
                'id'         => 'contact_location',
                'type'       => 'text',
                'title'      => esc_html__( 'Contact Link', 'utech' ),
                'desc'       => esc_html__( 'Set the mobile menu contact link here.', 'utech' ),
                'default'    => $author_uri,
                'dependency' => array( 'mobile_menu_style', 'any', 'left,right' ),
            ),
            array(
                'type'    => 'subheading',
                'content' => esc_html__( 'Mobile Menu Background', 'utech' ),
            ),
            array(
                'id'                    => 'mobile_menu_bg',
                'type'                  => 'background',
                'title'                 => esc_html__( 'Menu Background', 'utech' ),
                'subtitle'              => esc_html__( 'Set the menu background.', 'utech' ),
                'desc'                  => esc_html__( 'Set the menu background color, image and gradient color. If you set only first color field it will be a simple solid color for background and if set 2nd color field too it will be set a gradient color and if you set a image it will be set a background image.', 'utech' ),
                'background_image'      => true,
                'background_position'   => true,
                'background_repeat'     => true,
                'background_attachment' => true,
                'background_size'       => true,
                'background_gradient'   => true,
                'background_origin'     => true,
                'background_clip'       => true,
                'background_blend_mode' => true,
                'output'                => '.menu__mobile__style .mainmenu-area-bg',
            ),
            array(
                'id'          => 'mobile_menu_bg_opacity',
                'type'        => 'slider',
                'title'       => esc_html__( 'Background Opacity', 'utech' ),
                'desc'        => esc_html__( 'Set the menu background opacity here use max value 99 and minimum value 1 in decimal.', 'utech' ),
                'min'         => 0,
                'max'         => 1,
                'step'        => 0.01,
                'unit'        => ' ',
                'default'     => 1,
                'output_mode' => 'opacity',
                'output'      => '.menu__mobile__style .mainmenu-area-bg',
            ),
            array(
                'type'    => 'subheading',
                'content' => esc_html__( 'Mobile Menu Sticky Background', 'utech' ),
            ),
            array(
                'id'                    => 'mobile_menu_sticky_bg',
                'type'                  => 'background',
                'title'                 => esc_html__( 'Menu Sticky Background', 'utech' ),
                'subtitle'              => esc_html__( 'Set the menu sticky background.', 'utech' ),
                'desc'                  => esc_html__( 'Set the menu sticky background color, image and gradient color. If you set only first color field it will be a simple solid color for background and if set 2nd color field too it will be set a gradient color and if you set a image it will be set a background image.', 'utech' ),
                'background_image'      => true,
                'background_position'   => true,
                'background_repeat'     => true,
                'background_attachment' => true,
                'background_size'       => true,
                'background_gradient'   => true,
                'background_origin'     => true,
                'background_clip'       => true,
                'background_blend_mode' => true,
                'output'                => '.menu__mobile__style .is-sticky .mainmenu-area-bg',
            ),
            array(
                'id'          => 'mobile_menu_sticky_bg_opacity',
                'type'        => 'slider',
                'title'       => esc_html__( 'Sticky Background Opacity', 'utech' ),
                'desc'        => esc_html__( 'Set the menu sticky background opacity here use max value 99 and minimum value 1 in decimal.', 'utech' ),
                'min'         => 0,
                'max'         => 1,
                'step'        => 0.01,
                'unit'        => ' ',
                'default'     => 1,
                'output_mode' => 'opacity',
                'output'      => '.menu__mobile__style .is-sticky .mainmenu-area-bg',
            ),
            array(
                'type'    => 'subheading',
                'content' => esc_html__( 'Mobile Menu Color', 'utech' ),
            ),
            array(
                'id'      => 'mobile_menu_color',
                'type'    => 'color',
                'title'   => esc_html__( 'Menu Color', 'utech' ),
                'desc'    => esc_html__( 'Set the menu color by color picker', 'utech' ),
                'default' => '#00274e',
                'output'  => array(),
            ),
            array(
                'id'      => 'mobile_menu_hover',
                'type'    => 'color',
                'title'   => esc_html__( 'Menu Active & Hover Color', 'utech' ),
                'desc'    => esc_html__( 'Set the menu item active &hover color by color picker', 'utech' ),
                'default' => '#0045ff',
                'output'  => array(),
            ),
            array(
                'id'      => 'mobile_menu_hover_background',
                'type'    => 'color',
                'title'   => esc_html__( 'Menu Active Background Color', 'utech' ),
                'desc'    => esc_html__( 'Set the menu active background color by color picker', 'utech' ),
                'default' => '#ffffff',
                'output'  => array(),
            ),
            array(
                'type'    => 'subheading',
                'content' => esc_html__( 'Mobile Menu Hamburger Color & Background', 'utech' ),
            ),
            array(
                'id'      => 'mobile_menu_hamburger_color',
                'type'    => 'color',
                'title'   => esc_html__( ' Menu Hamburger Background', 'utech' ),
                'desc'    => esc_html__( 'Set the menu hamburger background color by color picker', 'utech' ),
                'default' => '#ffffff',
                'output'  => array(),
            ),
            array(
                'id'      => 'mobile_sticky_menu_hamburger_color',
                'type'    => 'color',
                'title'   => esc_html__( 'Sticky Menu Hamburger Background', 'utech' ),
                'desc'    => esc_html__( 'Set the menu hamburger color by color picker', 'utech' ),
                'default' => '#202030',
                'output'  => array(),
            ),
            array(
                'type'    => 'subheading',
                'content' => esc_html__( 'Mobile Menu Border', 'utech' ),
            ),
            array(
                'id'      => 'mobile_menu_border_color',
                'type'    => 'color',
                'title'   => esc_html__( 'Menu Bottom Border Color', 'utech' ),
                'desc'    => esc_html__( 'Set the menu border bottom color by color picker', 'utech' ),
                'default' => 'rgba(255,255,255,.15)',
                'output'  => array(),
            ),
        )
    )
);